<?php
/* ----------------------------------------------------------
Declare vars
------------------------------------------------------------- */
$themename = "WPA Italia Digitale";
$shortname = "wpaitaliadigitale";
$categories = get_categories('hide_empty=0&orderby=name');

$all_colors = array('red','green','blue','violet','brown','teal','yellow');
$social_channels_position=array('top-bar','above-search');
$where_company_details=array('top-bar','sidebar');
$footer_channels_position=array('si','no');
$num_sidebars = array('0','1','2','3','4','5','6','7','8','9','10');


/*---------------------------------------------------
register settings
----------------------------------------------------*/
function theme_settings_init(){
register_setting( 'theme_settings', 'theme_settings' );
wp_enqueue_style("panel_style", get_template_directory_uri()."/wptuts-upload/panel.css", false, "1.0", "all");
wp_enqueue_script("panel_script", get_template_directory_uri()."/wptuts-upload/panel_script.js", false, "1.0");
//wp_enqueue_script("panel_script", get_template_directory_uri()."/wptuts-upload/wptuts-upload.js", false, "1.0");
}

/*---------------------------------------------------
add settings page to menu
----------------------------------------------------*/
function add_settings_page() {
add_menu_page( __( 'WPA Italia Digitale' .' Theme Panel' ), __( 'WPA Italia Digitale' .' Theme Panel' ), 'manage_options', 'settings', 'theme_settings_page');

}

/*---------------------------------------------------
add actions
----------------------------------------------------*/
add_action( 'admin_init', 'theme_settings_init' );
add_action( 'admin_menu', 'add_settings_page' );

/* ---------------------------------------------------------
Declare options
----------------------------------------------------------- */

$theme_options = array (

array( "name" => $themename." Opzioni",
"type" => "title"),

/* ---------------------------------------------------------
General section
----------------------------------------------------------- */
array( "name" => "Opzioni tema",
"type" => "section"),
array( "type" => "open"),

array( "name" => "Logo",
"desc" => "",
"id" => $shortname."_logo",
"type" => "file",
"std" => ""),

array( "name" => "Footer Logo",
"desc" => "",
"id" => $shortname."_footer_logo",
"type" => "file",
"std" => ""),


array( "name" => "Colore primario",
"desc" => "",
"id" => $shortname."_main_color",
"type" => "select",
"options" => $all_colors,
"std" => "red"),

array( "type" => "close"),

/* ---------------------------------------------------------
Page URL section
----------------------------------------------------------- */
array( "name" => "Dettagli societari",
"type" => "section"),
array( "type" => "open"),

array( "name" => "Vuoi visualizzare i dettagli societari in testa alle pagine o vuoi gestire il testo tramite sidebar?",
"desc" => "top-bar indica che i dati societari verranno visualizzati in testa alle pagine: sidebar indica che il testo verr&agrave; impostato tramite il widget della Header Sidebar",
"id" => $shortname."_where_company_details",
"type" => "select",
"options" => $where_company_details,
"std" => "top-bar"),

array( "name" => "Indirizzo",
"desc" => "",
"id" => $shortname."_footer_indirizzo1",
"type" => "text",
"std" => ""),

array( "name" => "API Key Google Maps",
"desc" => "Senza l'API key fornita da Google Maps non sarà possibile visualizzare la mappa",
"id" => $shortname."_maps_api_key",
"type" => "text",
"std" => ""),

array( "name" => "Latitudine per mappa di Google",
"desc" => "",
"id" => $shortname."_maps_latitude",
"type" => "text",
"std" => ""),

array( "name" => "Longitudine per mappa di Google",
"desc" => "",
"id" => $shortname."_maps_longitude",
"type" => "text",
"std" => ""),

array( "name" => "Zoom mappa di Google",
"desc" => "",
"id" => $shortname."_maps_zoom",
"type" => "text",
"std" => ""),


array( "name" => "Telefono",
"desc" => "",
"id" => $shortname."_footer_telefono1",
"type" => "text",
"std" => ""),

array( "name" => "Fax",
"desc" => "",
"id" => $shortname."_footer_fax1",
"type" => "text",
"std" => ""),


array( "name" => "Email PEC",
"desc" => "",
"id" => $shortname."_email_pec",
"type" => "text",
"std" => ""),

array( "name" => "Partita IVA",
"desc" => "",
"id" => $shortname."_vat",
"type" => "text",
"std" => ""),

array( "name" => "Link pagina privacy policy",
"desc" => "",
"id" => $shortname."_privacy_policy",
"type" => "text",
"std" => ""),


array( "type" => "close"),


/* ---------------------------------------------------------
Social section
----------------------------------------------------------- */
array( "name" => "Canali social",
"type" => "section"),
array( "type" => "open"),

array( "name" => "Dove vuoi visualizzare i canali social?",
"desc" => "top-bar indica che verranno visualizzati nella barra grigia in testa ad ogni pagina del sito; above-search indica che verranno visualizzati appena sopra il modulo di ricerca.",
"id" => $shortname."_where_social_channels",
"type" => "select",
"options" => $social_channels_position,
"std" => "top-bar"),

array( "name" => "Vuoi visualizzare i canali social nel pi&egrave; di pagina?",
"desc" => "",
"id" => $shortname."_footer_social_channels",
"type" => "select",
"options" => $footer_channels_position,
"std" => "si"),

array( "name" => "Link Facebook",
"desc" => "",
"id" => $shortname."_social_facebook",
"type" => "text",
"std" => ""),

array( "name" => "Link Googleplus",
"desc" => "",
"id" => $shortname."_social_googleplus",
"type" => "text",
"std" => ""),

array( "name" => "Link Flickr",
"desc" => "",
"id" => $shortname."_social_flickr",
"type" => "text",
"std" => ""),

array( "name" => "Link Twitter",
"desc" => "",
"id" => $shortname."_social_twitter",
"type" => "text",
"std" => ""),

array( "name" => "Link YouTube",
"desc" => "",
"id" => $shortname."_social_youtube",
"type" => "text",
"std" => ""),

array( "type" => "close"),


/* ---------------------------------------------------------
Custom sidebars
----------------------------------------------------------- */
array( "name" => "Sidebars personalizzate",
"type" => "section"),
array( "type" => "open"),

array( "name" => "Numero di sidebar che si vogliono aggiungere:",
"desc" => "",
"id" => $shortname."_number_custom_sidebars",
"type" => "select",
"options" => $num_sidebars,
"std" => "0"),

array( "type" => "close")

);

/*---------------------------------------------------
Theme Panel Output
----------------------------------------------------*/
function theme_settings_page() {
	global $themename,$theme_options;
	$i=0;
	$message='';
	if ( 'save' == $_REQUEST['action'] ) {

		foreach ($theme_options as $value) {
			update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }

		foreach ($theme_options as $value) {
			if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } }
		$message='saved';
	}
	else if( 'reset' == $_REQUEST['action'] ) {

		foreach ($theme_options as $value) {
			delete_option( $value['id'] ); }
		$message='reset';
	}

	?>
	<div class="wrap options_wrap">
		<div id="icon-options-general"></div>
		<h2><?php _e( ' Theme Options' ) //your admin panel title ?></h2>
		<?php
		if ( $message=='saved' ) echo '<div class="updated settings-error" id="setting-error-settings_updated">
		<p>'.$themename.' settings saved.</strong></p></div>';
		if ( $message=='reset' ) echo '<div class="updated settings-error" id="setting-error-settings_updated">
		<p>'.$themename.' settings reset.</strong></p></div>';
		?>

		<div class="content_options">
			<form method="post" enctype="multipart/form-data">

			<?php foreach ($theme_options as $value) {

				switch ( $value['type'] ) {

					case "open": ?>
					<?php break;

					case "close": ?>
					</div>
					</div><br />
					<?php break;

					case "title": ?>
					<div class="message">
						<p>To easily use the <?php echo $themename;?> theme options, you can use the options below.</p>
					</div>
					<?php break;

					case 'text': ?>
					<div class="option_input option_text">
					<label for="<?php echo $value['id']; ?>">
					<?php echo $value['name']; ?></label>
					<input id="" type="<?php echo $value['type']; ?>" name="<?php echo $value['id']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo stripslashes(get_settings( $value['id'])  ); } else { echo $value['std']; } ?>" />
					<small><?php echo $value['desc']; ?></small>
					<div class="clearfix"></div>
					</div>
					<?php break;

					case 'textarea': ?>
					<div class="option_input option_textarea">
					<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
					<textarea name="<?php echo $value['id']; ?>" rows="" cols=""><?php if ( get_settings( $value['id'] ) != "") { echo stripslashes(get_settings( $value['id']) ); } else { echo $value['std']; } ?></textarea>
					<small><?php echo $value['desc']; ?></small>
					<div class="clearfix"></div>
					</div>
					<?php break;

					case 'select': ?>
					<div class="option_input option_select">
					<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
					<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
					<?php foreach ($value['options'] as $option) { ?>
							<option <?php if (get_settings( $value['id'] ) == $option) { echo 'selected="selected"'; } ?>><?php echo $option; ?></option>
					<?php } ?>
					</select>
					<small><?php echo $value['desc']; ?></small>
					<div class="clearfix"></div>
					</div>
					<?php break;

					case "checkbox": ?>
					<div class="option_input option_checkbox">
					<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
					<?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
					<input id="<?php echo $value['id']; ?>" type="checkbox" name="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
					<small><?php echo $value['desc']; ?></small>
					<div class="clearfix"></div>
					</div>
					<?php break;

					case "section":
					$i++; ?>
					<div class="input_section">
					<div class="input_title">

						<h3><?php echo $value['name']; ?></h3>
						<span class="submit"><input name="save<?php echo $i; ?>" type="submit" class="button-primary" value="Save changes" /></span>
						<div class="clearfix"></div>
					</div>
					<div class="all_options">
					<?php break;

					case 'file': ?>
					<div class="option_input option_file">
						<label for="<?php echo $value['id']; ?>">
						<?php echo $value['name']; ?></label>
						<input id="<?php echo $value['id']; ?>" type="text" name="<?php echo $value['id']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo stripslashes(get_settings( $value['id'])  ); } else { echo $value['std']; } ?>" />
						<input id="upload_<?php echo $value['id']; ?>" type="button" class="button" value="Upload image" />
						<small><?php echo $value['desc']; ?></small>

						<?php if ( get_settings( $value['id'] ) != "") { ?>
						<div class="clearfix"></div>
						<div id="upload_<?php echo $value['id']; ?>_preview" style="min-height: 100px;">
							<img style="max-width:100%;" src="<?php echo stripslashes(get_settings( $value['id'])  ); ?>" />
						</div>
						<?php } ?>
						<div class="clearfix"></div>


					<div class="clearfix"></div>
					</div>
					<?php break;


				}
			}?>
		  <input type="hidden" name="action" value="save" />
		  </form>
		  <form method="post">
			  <p class="submit">
			  <input name="reset" type="submit" value="Reset" />
			  <input type="hidden" name="action" value="reset" />
			  </p>
		  </form>
		</div>
		<div class="footer-credit">
			<p>WPA ITalia Digitale</p>
		</div>
	</div>
	<?php
}
?>