<?php
/**
 * The template part for displaying content
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since WPA Italia Digitale 2.2
 */
?>
		<article class="Grid-cell u-md-size11of12 u-lg-size11of12">
          <header class="Grid-cell Grid-details u-text-r-m u-color-white u-background-40 u-padding-top-xs u-padding-bottom-xs u-padding-left-s u-padding-right-s">
            <span class="u-text-r-xs Icon Icon-categoria" > </span><span class="u-text-r-xs" ><?php echo get_the_category_list( ', ', 'multiple'); ?></span>&nbsp;&nbsp;&nbsp;
            <span class="u-text-r-xs Icon Icon-comment" > </span><span class="u-text-r-xs" >
            <?php
              $num_comments = get_comments_number(get_the_ID());
              if ( $num_comments == 0 ) {
                echo '0 '.__('Comments','wpaitaliadigitale');
              } elseif ( $num_comments > 1 ) {
                echo $num_comments.' '. __('Comments','wpaitaliadigitale');
              } else {
                echo '1 '.__('Comment','wpaitaliadigitale');
              }
            ?></span> &nbsp;&nbsp;&nbsp;
            <span class="u-text-r-xs Icon Icon-calendar" > </span><span class="u-text-r-xs" ><?php echo get_the_date('j/m/Y'); ?></span>
          </header>
          <div class="Grid-cell Prose u-layout-release u-color-black u-margin-bottom-m">

            <?php
            if ( has_post_format( 'video' )) {
        			  if (types_render_field('video-url', array('raw' => 'true'))!='') echo '<div class="rwd-video"><iframe width="560" height="315" src="'.types_render_field('video-url', array('raw' => 'true')).'" allowfullscreen></iframe></div>';
        		}else if( has_post_format( 'gallery' )){
              $immagine=get_post_meta(get_the_ID(),'wpcf-image-gallery');

              if(sizeof($immagine)>=1 && $immagine[0]!=''){
                echo '<div class="flexslider"><ul class="slides">';
                  for ($t=0;$t<sizeof($immagine);$t++) {
                      echo '<li><img itemprop="image" src="'.$immagine[$t].'" alt="'.get_the_title().' '.$t.'" /></li>';
                  }
                echo '</ul></div>';
              }else if(get_the_post_thumbnail(get_the_ID(), 'full')!='') { $url = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) ); echo '<a data-lightbox="image-gallery" href="'.$url.'">'.get_the_post_thumbnail(get_the_ID(), 'full').'</a>'; }

           	}else{
               if ( has_post_thumbnail() )  the_post_thumbnail('full');
            }

            ?>


            </div>

          <div class="Grid-cell Prose u-layout-release u-color-black u-margin-bottom-m u-margin-top-m">
            <?php the_content(); ?>
          </div>

          <div class="u-cf u-padding-bottom-xl">
            <div class="Share Grid-cell u-sizeFull u-md-size11of12 u-lg-size11of12">
				<h4 class="Share-reveal js-Share u-text-h2">
				  <a href="#shareOptions" class="Share-revealText" id="showShareOptions">
					<span class="Share-revealIcon Icon Icon-share"></span>
					Condividi
				  </a>
				</h4>
				  <ul id="shareOptions" class="Dropdown-menu u-hidden" >
					<li><a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" target="_blank" title="Condivi su Facebook"><span class="Icon Icon-facebook"></span></a></li>
					<li><a href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>" target="_blank" title="Condivi su Twitter"><span class="Icon Icon-twitter"></span></a></li>
					<li><a href="https://plus.google.com/share?url=<?php the_permalink(); ?>" target="_blank" title="Condivi su GooglePlus"><span class="Icon Icon-googleplus"></span></a></li>
					<li><a href="mailto:?subject=<?php echo rawurlencode(get_the_title()); ?>&body=<?php the_permalink(); ?>" target="_blank" title="Condivi per email"><span class="Icon Icon-mail"></span></a></li>
					<li><a href="https://whatsapp.com/share?text=<?php echo rawurlencode(get_the_title()); ?>&url=<?php the_permalink(); ?>" target="_blank" title="Condivi su Whatsapp"><span class="Icon Icon-whatsapp"></span></a></li>
					<li class="close"><a id="closeShareOptions"  href="#" title="Chiudi"><span class="Icon Icon-close"></span></a></li>
				  </ul>
			  </div>

          </div>
		  <div class="u-cf u-padding-bottom-xl">
			<?php if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;  ?>
		  </div>

        </article>