<?php

/**

 * The template for displaying pages

 *

 * This is the template that displays all pages by default.

 * Please note that this is the WordPress construct of pages and that

 * other "pages" on your WordPress site will use a different template.

 *

 * @package WordPress

 * @subpackage Twenty_Sixteen

 * @since WPA Italia Digitale 2.2

 */



get_header();

$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

?>

<section id="main">

  <div class="u-layout-wide u-layoutCenter u-layout-withGutter u-padding-r-bottom u-padding-top-s">

      <nav aria-label="<?php echo __('You are here','wpaitaliadigitale'); ?>:" >

        <ol class="Breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">

          <?php if(function_exists('bcn_display'))

            {

                bcn_display();

            }?>

        </ol>

    </nav>

  </div>



	<div class="u-layout-wide u-layout-withGutter u-layoutCenter u-padding-r-top u-margin-bottom-l">

		<h1 class="u-text-h2"><?php echo __('Services','wpaitaliadigitale'); ?></h1>

		<div class="Grid Grid--withGutter">

			<div class="Grid-cell Grid-AreaTematica Grid-PaginaInterna u-md-size8of12 u-lg-size8of12 u-margin-bottom-l">

				<div class="Grid-cell u-sm-size1of2 u-md-size1of2 u-lg-size1of2 u-padding-r-all">

			        <div class="Grid-cell Grid-ListaAreetematiche u-border-top-l u-color-70 u-text-r-l u-padding-r-bottom">

			          <h2 class="u-text-h3 u-padding-r-top"><span class="u-text-r-l Icon Icon-servizi" ></span> <?php echo $term->name; ?></h2>

			          <ul>

						<?php

							query_posts($query_string.'&posts_per_page=-1');

							if (have_posts()) :

								while (have_posts()) : the_post();

									echo '<li><a href="'.get_the_permalink().'">'.get_the_title().'</a></li>';

								endwhile;

							endif;

							wp_reset_postdata();

			            ?>

			            </ul>

			        </div>

	      		</div>

	      	</div>

	      	<aside class="Grid-cell Grid-Sidebar u-sizeFull u-md-size4of12 u-lg-size4of12 u-margin-bottom-l" itemscope itemtype="http://schema.org/WPSideBar">

				<div class="u-cf u-padding-bottom-xl">

				  <div class="Share Grid-cell u-sizeFull u-md-size11of12 u-lg-size11of12">

					<h4 class="Share-reveal js-Share u-text-h2">

					  <a href="#shareOptions" class="Share-revealText" id="showShareOptions">

						<span class="Share-revealIcon Icon Icon-share"></span>

						Condividi

					  </a>

					</h4>

					  <ul id="shareOptions" class="Dropdown-menu u-hidden" >

						<li><a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" target="_blank" title="Condivi su Facebook"><span class="Icon Icon-facebook"></span></a></li>

						<li><a href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>" target="_blank" title="Condivi su Twitter"><span class="Icon Icon-twitter"></span></a></li>

						<li><a href="https://plus.google.com/share?url=<?php the_permalink(); ?>" target="_blank" title="Condivi su GooglePlus"><span class="Icon Icon-googleplus"></span></a></li>

						<li><a href="mailto:?subject=<?php echo rawurlencode(get_the_title()); ?>&body=<?php the_permalink(); ?>" target="_blank" title="Condivi per email"><span class="Icon Icon-mail"></span></a></li>

						<li><a href="https://whatsapp.com/share?text=<?php echo rawurlencode(get_the_title()); ?>&url=<?php the_permalink(); ?>" target="_blank" title="Condivi su Whatsapp"><span class="Icon Icon-whatsapp"></span></a></li>

						<li class="close"><a id="closeShareOptions"  href="#" title="Chiudi"><span class="Icon Icon-close"></span></a></li>

					  </ul>

				  </div>



				</div>



				<nav class="u-sizeFull u-md-size11of12 u-lg-size11of12" >

				  <h4 class="u-text-h3"><?php echo __('Related pages','wpaitaliadigitale'); ?></h4>

				  <?php

					wp_nav_menu( array('menu' => 'Services Menu', 'menu_class' => 'Linklist Linklist--padded u-layout-prose u-text-r-xs','container' => '' ));

				  ?>

				</nav>



				<a href="#" title="torna all'inizio del contenuto" class="u-hiddenVisually">torna all'inizio del contenuto</a>

			  </aside>

		</div>

	</div>

</section>

<?php

get_footer(); ?>

