<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since WPA Italia Digitale 2.2
 */

get_header();
$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
?>
<section id="main">
  <div class="u-layout-wide u-layoutCenter u-layout-withGutter u-padding-r-bottom u-padding-top-s">
      <nav aria-label="<?php echo __('You are here','wpaitaliadigitale'); ?>:" >
        <ol class="Breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">
          <?php if(function_exists('bcn_display'))
            {
                bcn_display();
            }?>
        </ol>
    </nav>
  </div>

    <div class="u-layout-wide u-layout-withGutter u-layoutCenter u-padding-r-top">
		<h1 class="u-text-h2"><?php echo __('Album','wpaitaliadigitale').': '.$term->name; ?></h1>
  			<div class="Grid Grid--withGutter u-margin-top-m margin-top-m u-text-r-l">
				<?php

					$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
  					query_posts($query_string.'&posts_per_page=6&paged='.$paged);
					if (have_posts()) :
						while (have_posts()) : the_post();
							get_template_part( 'template-parts/content', 'photo' );
						endwhile;
						echo '</div>';
						if ( function_exists( 'wpbeginner_numeric_posts_nav' ) )
							wpbeginner_numeric_posts_nav();
					endif;
	            ?>

  	</div>
</section>
<?php
get_footer(); ?>
