<?php
/**
 * The template for displaying all single posts and attachments
 *
 * @package WordPress
 * @subpackage WPA_Italia_Digitale
 * @since WPA Italia Digitale 2.2
 */

get_header();
while ( have_posts() ) : the_post(); ?>
<section id="main">
  <div class="u-layout-wide u-layoutCenter u-layout-withGutter u-padding-r-bottom u-padding-top-s">
      <nav aria-label="<?php echo __('You are here','wpaitaliadigitale'); ?>:" >
        <ol class="Breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">
          <?php if(function_exists('bcn_display'))
            {
                bcn_display();
            }?>
        </ol>
    </nav>
  </div>

  <div class="u-layout-wide u-layout-withGutter u-layoutCenter u-padding-r-top u-margin-bottom-l">
    <h1 class="u-text-h2 u-margin-bottom-l"><?php echo __('Press','wpaitaliadigitale').' - '.get_the_title(); ?></h1>
    <div class="Grid Grid--withGutter">
      <div class="Grid-cell Grid-AreaTematica Grid-PaginaInterna u-md-size12of12 u-lg-size12of12 ">

        <article class="Prose u-layout-release u-margin-bottom-xl">

          <h2 class="u-text-h3 u-color-40 u-margin-bottom-s"><?php echo get_the_date('l j F Y'); ?></h2>

          <?php if (types_render_field('file-attachment', array('raw' => 'true'))!=''){ ?>
            <table class="Table Table--flip u-text-r-m">
              <thead style="width: 20%;min-width: 20%">
                  <tr class="u-layout-prose " style="width: 100%;min-width: 100%">
                      <th>
                         <?php the_title(); ?>
                      </th>
                  </tr>
                </thead>
                <tbody style="width: 80%;min-width: 80%">
                    <tr class="u-layout-prose " style="width: 30%;min-width: 30%">
                        <?php
						echo '<td><a href="'.types_render_field('file-attachment', array('raw' => 'true')).'" target="_blank">';
                        

                        if(pathinfo(types_render_field('file-attachment', array('raw' => 'true')), PATHINFO_EXTENSION)=='pdf')
                            echo '<span class="u-text-r-l Icon Icon-pdf u-text-color-black"></span> '.pathinfo(types_render_field('file-attachment', array('raw' => 'true')), PATHINFO_BASENAME);
                        else if(pathinfo(types_render_field('file-attachment', array('raw' => 'true')), PATHINFO_EXTENSION)=='doc' || pathinfo(types_render_field('file-attachment', array('raw' => 'true')), PATHINFO_EXTENSION)=='docx')
                            echo '<span class="u-text-r-l Icon Icon-file u-text-color-black"></span> '.pathinfo(types_render_field('file-attachment', array('raw' => 'true')), PATHINFO_BASENAME);
                        else
                            echo '<span class="u-text-r-l Icon Icon-copy u-text-color-black"></span> '.pathinfo(types_render_field('file-attachment', array('raw' => 'true')), PATHINFO_BASENAME);
                         ?>
                        </a></td>
                    </tr>
                    <tr class="u-layout-prose u-sizeFull u-text-r-xxs" style="width: 70%;min-width: 70%">
                        <td><?php the_content(); ?></td>
                    </tr>
                </tbody>
          </table>
          <?php } ?>
        </article>
      </div>
    </div>
</div>
</section>
<?php endwhile; get_footer(); ?>