<?php
/**
 * The template for displaying search results pages.
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since WPA Italia Digitale 2.2
 */

get_header(); ?>
<section id="main">
	<div class="u-layout-wide u-layoutCenter u-layout-withGutter u-padding-r-bottom u-padding-top-s">
	      <nav aria-label="<?php echo __('You are here','wpaitaliadigitale'); ?>:" >
	        <ol class="Breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">
	          <?php if(function_exists('bcn_display'))
	            {
	                bcn_display();
	            }?>
	        </ol>
	    </nav>
	</div>

  <div class="u-layout-wide u-layout-withGutter u-layoutCenter u-padding-r-top u-margin-bottom-l">
    	<h1 class="u-text-h2"><?php printf( __( 'Search Results for: %s', 'wpaitaliadigitale' ), get_search_query() ); ?></h1>
		<div class="Grid Grid--withGutter">
	      	<div class="Grid-cell Grid-AreaTematica Grid-PaginaInterna u-md-size12of12 u-lg-size12of12 u-margin-bottom-l">


					<?php
					if ( have_posts() ) :

					while ( have_posts() ) : the_post();

						if ( get_query_var('paged') ) {
					        $paged = get_query_var('paged');
					        } else if ( get_query_var('page') ) {
					        $paged = get_query_var('page');
					        } else {
					        $paged = 1;
					    }

						echo '<article class="Grid-cell Prose u-layout-release u-color-black u-margin-bottom-m u-margin-top-m"><h2 class="u-text-h3"><a href="'.get_the_permalink().'">'.get_the_title().'</a></h2>';
						echo '<p>'.get_the_excerpt();
						echo '</p></srticle>';
					endwhile;

					wpbeginner_numeric_posts_nav();

					else :
						echo '<div class="Grid-cell Prose u-layout-release u-color-black u-margin-bottom-m u-margin-top-m"><h2 class="u-text-h3">'.__( 'Nothing found', 'wpaitaliadigitale' ).'!</h2><p>'.__( 'Please try with different search criteria', 'wpaitaliadigitale' ).'.</p></div>';
						get_search_form();
					endif;
					?>

      		</div>
    	</div>
	</div>
</section>
<?php get_footer(); ?>
