<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since WPA Italia Digitale 2.2
       Template Name: Services
 */

get_header();
while ( have_posts() ) : the_post(); ?>
<section id="main">
  <div class="u-layout-wide u-layoutCenter u-layout-withGutter u-padding-r-bottom u-padding-top-s">
      <nav aria-label="<?php echo __('You are here','wpaitaliadigitale'); ?>:" >
        <ol class="Breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">
          <?php if(function_exists('bcn_display'))
            {
                bcn_display();
            }?>
        </ol>
    </nav>
  </div>

	<div class="u-layout-wide u-layout-withGutter u-layoutCenter u-padding-r-top u-margin-bottom-l">
    

          <?php
            $terms = get_terms('categoria-servizio');
			$category_count=count($terms);
            if(!empty($terms)){
				
				
				echo '<h1 class="u-text-h2">'.get_the_title().'</h1><div class="Grid Grid--withGutter">';
				foreach( $terms as $term ):
					if($category_count==1)
						echo '<div class="Grid-cell u-sm-size2of2 u-md-size2of2 u-lg-size2of2 u-padding-r-all">';
					if($category_count==2)
						echo '<div class="Grid-cell u-sm-size1of2 u-md-size1of2 u-lg-size1of2 u-padding-r-all">';
					else
						echo '<div class="Grid-cell u-sm-size1of2 u-md-size1of2 u-lg-size1of3 u-padding-r-all">';
					
					
					echo '<div class="Grid-cell Grid-ListaAreetematiche u-border-top-l u-color-70 u-text-r-l u-padding-r-bottom">';
					echo '<h2 class="u-text-h3 u-padding-r-top"><span class="u-text-r-l Icon Icon-servizi" ></span> '.$term->name.'</h2>';
					echo '<ul>';

						$posts = get_posts(array(
						  'post_type' => 'servizio',
						  'taxonomy' => $term->taxonomy,
						  'term' => $term->slug,
						  'nopaging' => true,
						));
						foreach($posts as $post):
						  setup_postdata($post);

						  echo '<li><a href="'.get_the_permalink().'">'.get_the_title().'</a></li>';
						 endforeach;
					 echo '</ul>';
					 echo '</div></div>';
				endforeach;
				echo '</div>';
			}else{
				
				echo '<div class="Grid-cell u-sm-size1of2 u-md-size1of2 u-lg-size1of3 u-padding-r-all"><div class="Grid-cell Grid-ListaAreetematiche u-border-top-l u-color-70 u-text-r-l u-padding-r-bottom">';
					echo '<h1 class="u-text-h2 u-padding-r-top"><span class="u-text-r-l Icon Icon-servizi" ></span> '.get_the_title().'</h1>';
					echo '<ul>';

						$posts = get_posts(array(
						  'post_type' => 'servizio',
						  'nopaging' => true
						));
						foreach($posts as $post):
						  setup_postdata($post);

						  echo '<li><a href="'.get_the_permalink().'">'.get_the_title().'</a></li>';
						 endforeach;
					 echo '</ul>';
					 echo '</div></div>';
			}?>

	</div>
</section>
<?php endwhile;
get_footer(); ?>
