<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since WPA Italia Digitale 2.2
 Template Name: Institutions
 */

get_header();
while ( have_posts() ) : the_post(); ?>
<section id="main">
  <div class="u-layout-wide u-layoutCenter u-layout-withGutter u-padding-r-bottom u-padding-top-s">
     <nav aria-label="<?php echo __('You are here','wpaitaliadigitale'); ?>:" >
        <ol class="Breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">
          <?php if(function_exists('bcn_display'))
            {
                bcn_display();
            }?>
        </ol>
    </nav>
  </div>

    <div class="u-layout-wide u-layout-withGutter u-layoutCenter u-padding-r-top">
		<h1 class="u-text-h2"><?php the_title(); ?></h1>
			<div class="Grid Grid--withGutter">
			<?php

			$args = array(
				'post_type' => 'istituzione',
				'orderby' => 'post_date',
				'posts_per_page' => -1
			);
			$query = new WP_Query($args);
			if($query->have_posts()) : while ($query->have_posts()) : $query->the_post();

				echo '<div class="Grid-cell u-sm-size1of3 u-md-size1of3 u-lg-size1of3 u-padding-r-all">
		        <div class="Grid-cell Grid-ListaAreetematiche u-border-top-l u-color-70 u-text-r-l u-padding-r-bottom">
		          <h2 class="u-text-h3 u-padding-r-top"><span class="u-text-r-l Icon Icon-istituzioni" ></span> '.get_the_title().'</h2>';
		          echo '<p>'.get_the_excerpt().'</p>';
		          echo '<ul ><li><a href="'.get_the_permalink().'">'.__('Read more','wpaitaliadigitale').'</a></li></ul></div></div>';
			endwhile;
			endif;
			wp_reset_postdata();
			 ?>

		</div>

	  </div>
</section>
<?php endwhile;
get_footer(); ?>
