<?php

/**

 * The template for displaying pages

 *

 * This is the template that displays all pages by default.

 * Please note that this is the WordPress construct of pages and that

 * other "pages" on your WordPress site will use a different template.

 *

 * @package WordPress

 * @subpackage Twenty_Sixteen

 * @since WPA Italia Digitale 2.2

  Template Name: Home

 */



get_header();

if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

<section id="main">

	<?php 

	if ( class_exists( 'RevSlider' ) ) { //Checking that the class exists will prevent you from running into errors in your plugin or theme if Revolution Slider is deactivated or deleted for some reason.

		$rev_slider = new RevSlider();

		$sliders = $rev_slider->getAllSliderAliases();

		if (in_array("home_slider", $sliders)){

		?>

		  <div class="u-background-white u-color-black u-text-xxl ">

			 <?php echo do_shortcode('[rev_slider alias="home_slider"]'); ?>

		  </div>

		<?php 

		} 

	} ?>

  <div class="u-layout-wide u-layoutCenter u-padding-r-bottom u-padding-r-top u-margin-r-bottom u-margin-r-top u-layout-r-withGutter">

    <h1 class="u-text-h1"><?php the_title(); ?></h1>

    <?php the_content(); ?>

  </div>



  <?php

		//boxes under page content

 

		$countbox=0;

		

		for($i=1; $i<=8; $i++)

          if (types_render_field('box-'.$i.'-image', array('raw' => 'true'))!='' && types_render_field('box-'.$i.'-title', array('raw' => 'true'))!='')

			$countbox++;

		

		if($countbox > 0){

			echo '<div class="u-layout-wide u-layoutCenter u-padding-r-bottom u-padding-r-top u-margin-r-bottom u-margin-r-top u-layout-r-withGutter"><div class="Grid Grid--withGutter">';

			

			for($i=1; $i<=8; $i++){

			  if (types_render_field('box-'.$i.'-image', array('raw' => 'true'))!='' && types_render_field('box-'.$i.'-title', array('raw' => 'true'))!=''){

				  

				  if ($countbox==1)

					  echo '<div class="Grid-cell  u-margin-bottom-s">';

				  else if($countbox==2)

					  echo '<div class="Grid-cell u-sm-size1of2 u-md-size1of2 u-lg-size1of2 u-margin-bottom-s">';

				  else if($countbox==3 || $countbox==5 || $countbox==6)

					  echo '<div class="Grid-cell u-sm-size1of3 u-md-size1of3 u-lg-size1of3 u-margin-bottom-s">';

				  else if($countbox==4 || $countbox==7 || $countbox==8)

					  echo '<div class="Grid-cell u-sm-size2of4 u-md-size1of4 u-lg-size1of4 u-margin-bottom-s">';

				  

				  

				  

				   echo ' <div class="Entrypoint-item Entrypoint--nomargin Entrypoint--custom u-background-50 u-color-white"><p>';

					  

					  if (types_render_field('box-'.$i.'-link', array('raw' => 'true'))!='') echo '<a href="'.types_render_field('box-'.$i.'-link', array('raw' => 'true')).'">';

					  echo types_render_field('box-'.$i.'-title', array('raw' => 'true'));

					  if (types_render_field('box-'.$i.'-link', array('raw' => 'true'))!='') echo '</a>';

					  

					  echo '</p></div><img class="u-sizeFull" src="'.types_render_field('box-'.$i.'-image', array('raw' => 'true')).'" alt="'.types_render_field('box-'.$i.'-title', array('raw' => 'true')).'"></div>';

			  }

			}

			

			echo '</div></div>';

		}





		

		//blog

		$args = array(

			'post_type' => 'post',

			'orderby' => 'post_date',

			'posts_per_page' => 3

		  );

		  $query = new WP_Query($args);

		  if($query->have_posts()) :

	?>



		  <div class="u-background-white u-text-r-xxl u-padding-r-top u-padding-r-bottom">

			<div class="u-layout-wide u-layoutCenter u-layout-r-withGutter">

			  <div class="u-layout-centerContent">

				<div class="u-layout-wide">





				  <div class="Grid Grid--withGutter">

					<div class="Grid-cell <?php $sidebar_select = get_post_meta (get_the_ID(), "custom-sidebar-number", true ); if( $sidebar_select !="" && is_active_sidebar( $sidebar_select )) echo 'u-md-size3of4 u-lg-size3of4'; else echo 'u-md-size4of4 u-lg-size4of4'; ?>">



					  <div class="Grid u-padding-right-l">

						  <div class="Grid-cell u-sm-size3of4 u-md-size3of4 u-lg-size3of4 u-margin-bottom-l">

							<h2 class="u-text-h2"><?php if(types_render_field('title-before-news-section', array('raw' => 'true'))!='') echo types_render_field('title-before-news-section', array('raw' => 'true')); else echo __('Recent news and events','wpaitaliadigitale'); ?></h2>

						  </div>

					  </div>



					  <?php while ($query->have_posts()) : $query->the_post();

						echo '<article class="Grid-cell Card u-md-size4of4 u-lg-size4of4 u-margin-bottom-l u-padding-right-l">

						<div class="Grid Grid--withGutter u-padding-all-none">';

						  if(get_the_post_thumbnail($post->ID, 'full')!='')

							echo '<div class="Grid-cell u-md-size1of2 u-lg-size1of2"><a href="'.get_the_permalink().'">'.get_the_post_thumbnail(get_the_ID(), 'full',array('class' => 'u-sizeFull')).'</a></div>';



						  if(get_the_post_thumbnail($post->ID, 'full')!='') echo '<div class="Grid-cell u-md-size1of2 u-lg-size1of2">'; else echo '<div class="Grid-cell u-md-size2of2 u-lg-size2of2">';

						  echo '<div class="u-color-black u-padding-r-none">

							  <header class="Grid-details u-color-white u-background-40 u-padding-all-s u-margin-all-none">

								<span class="u-text-r-xxs Icon Icon-categoria" > </span><span class="u-text-r-xs " >'.get_the_category_list( ', ', 'multiple').'</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

								<span class="u-text-r-xxs Icon Icon-comment" > </span><span class="u-text-r-xs " >';



								$num_comments = get_comments_number(get_the_ID());

								if ( $num_comments == 0 ) {

								  echo '0 '.__('Comments','wpaitaliadigitale');

								} elseif ( $num_comments > 1 ) {

								  echo $num_comments . ' ' .__('Comments','wpaitaliadigitale');

								} else {

								  echo '1 '.__('Comment','wpaitaliadigitale');

								}



								echo '</span>&nbsp;&nbsp;&nbsp;&nbsp;

								<span class="u-text-r-xxs Icon Icon-calendar" > </span><span class="u-text-r-xs " >'.get_the_date('j/m/Y').'</span>

							  </header>

							  <h3 class="u-padding-r-top u-padding-r-bottom"><a class="u-text-h4 u-textClean u-color-black" href="'.get_the_permalink().'">

								'.get_the_title().'

								</a>

							  </h3>

							  <p>'.get_the_excerpt().'</p>

							</div>



						  </div>

						</div>

					  </article>';





					  endwhile;

					  

					  ?>



					</div>



					<?php 

					

					if( $sidebar_select !="" && is_active_sidebar( $sidebar_select )) : 

						echo '<aside class="Grid-cell Grid-Sidebar u-md-size1of4 u-lg-size1of4" itemscope itemtype="http://schema.org/WPSideBar">';

						dynamic_sidebar( $sidebar_select ); 

						echo '</aside>';

					endif;

					?>



				  </div>



				</div>

			  </div>



			</div>

		  </div>



<?php



			endif;

			wp_reset_postdata();

					

					

					  

			//photos		  

          $args = array(

            'post_type' => 'galleria-foto',

            'orderby' => 'post_date',

            'posts_per_page' => 9

          );

          $query = new WP_Query($args);

          if($query->have_posts()) :

 ?>

  <div class="u-background-70 u-padding-r-top u-padding-r-bottom u-text-r-xxl">

    <div class="u-padding-r-all">

      <div class="u-layout-medium u-layoutCenter">



        <div class="Grid">

          <h2 class="Grid-cell u-text-h2 u-color-white u-layout-centerLeft"><?php if(types_render_field('title-before-photos-section', array('raw' => 'true'))!='') echo types_render_field('title-before-photos-section', array('raw' => 'true')); else echo __('Latest published photos','wpaitaliadigitale'); ?></h2>



          <div class="Grid-cell u-layout-centerRight">

            <button class="owl-prev u-padding-bottom-xl u-padding-right-xxl u-text-r-xl u-color-white"

              aria-controls="carousel-1">

                <span class="u-hiddenVisually">Vai alla slide precedente</span>

                <span class="u-alignMiddle Icon Icon-arrow-left" role="presentation"></span>

            </button>

            <button class="owl-next u-padding-bottom-xl u-padding-left u-text-r-xl u-color-white"

              aria-controls="carousel-1">

              <span class="u-hiddenVisually">Vai alla slide successiva</span>

              <span class="u-alignMiddle Icon Icon-arrow-right" role="presentation"></span>

            </button>

            <p class="u-hiddenVisually">È possibile navigare le slide utilizzando i tasti freccia</p>

          </div>

        </div>



        <div class="owl-carousel owl-theme" role="region" id="carousel-1">

          <?php while ($query->have_posts()) : $query->the_post();

                echo '<article class="Carousel-item">

                  <div class="u-color-grey-30">

                    <figure>';



                      if(get_the_post_thumbnail(get_the_ID(), 'full')!=''){

                        $url = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) );

                        echo '<a href="'.$url.'" data-lightbox="galleriaFoto" class="u-block u-padding-all-xxs">

                          <img class="u-sizeFull" src="'.$url.'" alt="'.get_the_title().'" /></a>';

                      }



                      echo '<figcaption class="u-padding-all-xs u-margin-r-top">';



                      $listTerms=array();

                      $terms = get_the_terms(get_the_ID() , 'album' );

                      if ( $terms != null ){

                           echo '<span class="Icon Icon-camera u-color-grey-30 u-floatLeft u-text-r-l u-margin-right-xs" aria-hidden="true"></span><p class="u-color-grey-30 u-text-r-xs u-textWeight-700 u-padding-bottom-s">';

                              foreach( $terms as $key => $term ) {

                                if ($key == end(array_keys($terms)))

                                  echo $term->name;

                                else

                                  echo $term->name.', ';

                              }

                           echo '</p>';

                        }





                        echo '<div class="Grid">

                          <h3 class="Card-title u-textClean u-color-white u-textWeight-400 u-text-r-s ">

                            '.get_the_title().'

                          </h3>

                        </div>

                      </figcaption>

                    </figure>

                  </div>

                </article>';

          endwhile; ?>

        </div>



      </div>

    </div>



  </div>

<?php endif; wp_reset_postdata(); ?>

</section>



<?php endwhile; endif;

get_footer(); ?>