<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage WPA_Italia_Digitale
 * @since WPA Italia Digitale 2.2
 */

?><!DOCTYPE html>
<!--[if IE 8]><html class="no-js ie89 ie8" lang="it"><![endif]-->
<!--[if IE 9]><html class="no-js ie89 ie9" lang="it"><![endif]-->
<!--[if (gte IE 9)|!(IE)]><!-->
<html class="no-js" <?php language_attributes(); ?>>
<!--<![endif]-->

<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="profile" href="http://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php endif; ?>

  <script type="text/javascript">
    WebFontConfig = {
      google: {
        families: ['Titillium+Web:400,600,700,400italic:latin']
      }
    };
    (function() {
      var wf = document.createElement('script');
      wf.src = 'https://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
      wf.type = 'text/javascript';
      wf.async = 'true';
      var s = document.getElementsByTagName('script')[0];
      s.parentNode.insertBefore(wf, s);
    })();
  </script>

	<?php wp_head(); ?>
</head>

<body <?php $classBody='Red';
  if ( get_option('wpaitaliadigitale_main_color') != '' ){
      if ( get_option('wpaitaliadigitale_main_color') == 'red' )
        $classBody='Red';
      else if ( get_option('wpaitaliadigitale_main_color') == 'green' )
        $classBody='Green';
      else if ( get_option('wpaitaliadigitale_main_color') == 'blue' )
         $classBody='Blue';
	  else if ( get_option('wpaitaliadigitale_main_color') == 'violet' )
         $classBody='Violet';
	  else if ( get_option('wpaitaliadigitale_main_color') == 'brown' )
         $classBody='Brown';
	  else if ( get_option('wpaitaliadigitale_main_color') == 'teal' )
         $classBody='Teal';
	  else if ( get_option('wpaitaliadigitale_main_color') == 'yellow' )
         $classBody='Yellow';

  }

  body_class($classBody); ?> itemscope itemtype="http://schema.org/WebPage">


<ul class="Skiplinks js-fr-bypasslinks">
  <li><a accesskey="2" href="#main"><?php echo __('Go to content','wpaitaliadigitale'); ?></a></li>
  <li><a accesskey="3" href="#menu"><?php echo __('Go to site navigation','wpaitaliadigitale'); ?></a></li>
</ul>


<header class="Header Headroom--fixed" itemtype="http://schema.org/WPHeader" itemscope>
  <div class="Header-top Headroom-hideme Grid Grid--alignMiddle u-background-grey-80 u-color-white">

		<?php if ( get_option('wpaitaliadigitale_where_social_channels')== 'top-bar' && (get_option('wpaitaliadigitale_social_facebook') != '' || get_option('wpaitaliadigitale_social_googleplus') != '' || get_option('wpaitaliadigitale_social_flickr') != '' || get_option('wpaitaliadigitale_social_twitter') != '' || get_option('wpaitaliadigitale_social_youtube') != ''))
				echo '<div class="Grid-cell usizefull u-size2of3 u-lg-size2of3 u-padding-all-xs">';
			else 
				echo '<div class="Grid-cell usizefull u-size1of1 u-lg-size1of1 u-padding-all-xs u-textCenter">';
						if(get_option('wpaitaliadigitale_where_company_details')== 'top-bar'){
							echo '<p>';
								if(get_option('wpaitaliadigitale_footer_indirizzo1') != '') echo '<span class="Icon Icon-indirizzo"></span> Indirizzo: '.get_option('wpaitaliadigitale_footer_indirizzo1').' &nbsp; &nbsp; ';
								if(get_option('wpaitaliadigitale_footer_telefono1') != '') echo '<span class="Icon Icon-telefono"></span> Telefono: '.get_option('wpaitaliadigitale_footer_telefono1').' &nbsp; &nbsp; '; 
								if(get_option('wpaitaliadigitale_footer_fax1') != '') echo '<span class="Icon Icon-fax"></span> Fax: '.get_option('wpaitaliadigitale_footer_fax1').' &nbsp; &nbsp; ';
								if(get_option('wpaitaliadigitale_email_pec') != '') echo '<span class="Icon Icon-mail"></span> Email: '.get_option('wpaitaliadigitale_email_pec').' &nbsp; &nbsp; ';
								if(get_option('wpaitaliadigitale_vat') != '') echo '<span class="Icon Icon-file"></span> P.IVA: '.get_option('wpaitaliadigitale_vat');
							echo '</p>';
						}else if(get_option('wpaitaliadigitale_where_company_details')== 'sidebar'){
							if ( is_active_sidebar( 'header-sidebar' ) ) :
								dynamic_sidebar( 'header-sidebar' );
							endif;
						}
						
			echo '</div>';
			

			if ( get_option('wpaitaliadigitale_where_social_channels')== 'top-bar' && (get_option('wpaitaliadigitale_social_facebook') != '' || get_option('wpaitaliadigitale_social_googleplus') != '' || get_option('wpaitaliadigitale_social_flickr') != '' || get_option('wpaitaliadigitale_social_twitter') != '' || get_option('wpaitaliadigitale_social_youtube') != '')){  
	        echo '<div class="Grid-cell  usizefull u-size1of3 u-lg-size1of3 u-padding-all-xs"><ul class="Header-socialIcons">';
          
				  if ( get_option('wpaitaliadigitale_social_facebook') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_facebook').'"><span class="Icon Icon-facebook"></span><span class="u-hiddenVisually">Facebook</span></a></li>';
				  if ( get_option('wpaitaliadigitale_social_twitter') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_twitter').'"><span class="Icon Icon-twitter"></span><span class="u-hiddenVisually">Twitter</span></a></li>';
				  if ( get_option('wpaitaliadigitale_social_youtube') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_youtube').'"><span class="Icon Icon-youtube"></span><span class="u-hiddenVisually">Youtube</span></a></li>';
				  if ( get_option('wpaitaliadigitale_social_googleplus') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_googleplus').'"><span class="Icon Icon-googleplus"></span><span class="u-hiddenVisually">Googleplus</span></a></li>';
				  if ( get_option('wpaitaliadigitale_social_flickr') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_youtube').'"><span class="Icon Icon-flickr"></span><span class="u-hiddenVisually">Flickr</span></a></li>';
	         
			echo '</ul></div>';
       	 } ?>
          
      
  </div>
  
  <div class="Header-navbar Grid Grid--alignMiddle">

    <div class="Header-toggle Grid-cell">
      <a class="Hamburger-toggleContainer js-fr-offcanvas-open" href="#menu"
        aria-controls="menu" aria-label="Accedi al menu" title="accedi al menu">
        <span class="Hamburger-toggle" role="presentation"></span>
        <span class="Header-toggleText" role="presentation"><?php echo __('Menu','wpaitaliadigitale'); ?></span>
      </a>
    </div>

    <div class="Header-logo Grid-cell" aria-hidden="true">
      <a href="<?php echo  home_url('/'); ?>" tabindex="-1">
        <?php
          if ( get_option('wpaitaliadigitale_logo') != '' )
            echo '<img src="'.get_option('wpaitaliadigitale_logo').'" alt="'.get_bloginfo('name').'" />';
          else
            echo '<img src="'.get_template_directory_uri().'/images/logo-wpa-bianco.png" alt="'.get_bloginfo('name').'" />';
         ?>
      </a>
    </div>

    <div class="Header-title Grid-cell">
      <p class="Header-titleLink">
        <a accesskey="1" href="<?php echo  home_url('/'); ?>">
          <span itemprop="headline"><?php echo bloginfo('name'); ?></span><br><small itemprop="description"><?php echo bloginfo('description'); ?></small>
        </a>
      </p>
    </div>

    <div class="Header-searchTrigger Grid-cell">
      <button aria-controls="header-search" class="js-Header-search-trigger Icon Icon-search"
        title="<?php echo __('Activate search form','wpaitaliadigitale'); ?>" aria-label="<?php echo __('Activate search form','wpaitaliadigitale'); ?>" aria-hidden="false">
      </button>
      <button aria-controls="header-search" class="js-Header-search-trigger Icon Icon-close u-hiddenVisually"
        title="<?php echo __('Deactivate search form','wpaitaliadigitale'); ?>" aria-label="<?php echo __('Deactivate search form','wpaitaliadigitale'); ?>" aria-hidden="true">
      </button>
    </div>

    <div class="Header-utils Grid-cell">
		
      	<?php if ( get_option('wpaitaliadigitale_where_social_channels')== 'above-search' && (get_option('wpaitaliadigitale_social_facebook') != '' || get_option('wpaitaliadigitale_social_googleplus') != '' || get_option('wpaitaliadigitale_social_flickr') != '' || get_option('wpaitaliadigitale_social_twitter') != '' || get_option('wpaitaliadigitale_social_youtube') != '')){  
	        echo '<div class="Header-social Headroom-hideme"><p>'.__('Follow us','wpaitaliadigitale').':</p><ul class="Header-socialIcons">';
	       
	          if ( get_option('wpaitaliadigitale_social_facebook') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_facebook').'"><span class="Icon Icon-facebook"></span><span class="u-hiddenVisually">Facebook</span></a></li>';
	          if ( get_option('wpaitaliadigitale_social_twitter') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_twitter').'"><span class="Icon Icon-twitter"></span><span class="u-hiddenVisually">Twitter</span></a></li>';
	          if ( get_option('wpaitaliadigitale_social_youtube') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_youtube').'"><span class="Icon Icon-youtube"></span><span class="u-hiddenVisually">Youtube</span></a></li>';
	          if ( get_option('wpaitaliadigitale_social_googleplus') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_googleplus').'"><span class="Icon Icon-googleplus"></span><span class="u-hiddenVisually">Googleplus</span></a></li>';
	          if ( get_option('wpaitaliadigitale_social_flickr') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_youtube').'"><span class="Icon Icon-flickr"></span><span class="u-hiddenVisually">Flickr</span></a></li>';
	          
			echo '</ul></div>';
       	 } ?>
      

      <div class="Header-search" id="header-search">
        <?php get_search_form(); ?>

      </div>

    </div>

  </div><!-- Header-navbar -->

  <div class="Headroom-hideme u-textCenter u-hidden u-sm-block u-md-block u-lg-block">
      <nav class="Megamenu Megamenu--styled js-megamenu" data-rel=".Offcanvas .Treeview" ></nav>
  </div>


</header>
<div class="Offcanvas Offcanvas--left Offcanvas--modal js-fr-offcanvas u-jsVisibilityHidden u-nojsDisplayNone" id="menu">
    <span class="u-hiddenVisually"><?php echo __('Main menu','wpaitaliadigitale'); ?></span>
    <div class="Offcanvas-content u-background-white">
        <div class="Offcanvas-toggleContainer u-background-70 u-jsHidden">
            <a class="Hamburger-toggleContainer u-block u-color-white u-padding-bottom-xxl u-padding-left-s u-padding-top-xxl js-fr-offcanvas-close" aria-controls="menu" aria-label="<?php echo __('Close navigation','wpaitaliadigitale'); ?>" title="<?php echo __('Close navigation','wpaitaliadigitale'); ?>" href="#">
                <span class="Hamburger-toggle is-active" aria-hidden="true"></span>
            </a>
        </div>
        <nav>
        	<?php $menuargs = array('menu_class'=>'Linklist Linklist--padded Treeview Treeview--default js-fr-treeview u-text-r-xs','theme_location'=>'primary-menu','container'=>'','menu_id'=>'');
        	wp_nav_menu($menuargs);
        	?>
        </nav>
    </div>
</div>