<?php
/**
 * The template for displaying archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each one. For example, tag.php (Tag archives),
 * category.php (Category archives), author.php (Author archives), etc.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since WPA Italia Digitale 2.2
 */

get_header(); ?>
<section id="main">
	<div class="u-layout-wide u-layoutCenter u-layout-withGutter u-padding-r-bottom u-padding-top-s">
	      <nav aria-label="<?php echo __('You are here','wpaitaliadigitale'); ?>:" >
		        <ol class="Breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">
		          <?php if(function_exists('bcn_display'))
		            {
		                bcn_display();
		            }?>
		        </ol>
		    </nav>
	</div>

	<div class="u-layout-wide u-layout-withGutter u-layoutCenter u-padding-r-top u-margin-bottom-l">
	  <h1 class="u-text-h2">
		<?php
			if ( have_posts() ) :
				if ( is_day() ) :
					printf( __( 'Archive: %s', 'wpaitaliadigitale' ), get_the_date() );

				elseif ( is_month() ) :
					printf( __( 'Archive: %s', 'wpaitaliadigitale' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'wpaitaliadigitale' ) ) );

				elseif ( is_year() ) :
					printf( __( 'Archive: %s', 'wpaitaliadigitale' ), get_the_date( _x( 'Y', 'yearly archives date format', 'wpaitaliadigitale' ) ) );

				else :
					echo __( 'Archive', 'wpaitaliadigitale' );
				endif;
			endif;
		 ?>
	  </h1>
	  <div class=" u-layout-centerContent u-cf">
	      <div class="js-Masonry-container u-layout-large" data-columns>
				<?php
				while ( have_posts() ) : the_post();
					get_template_part( 'template-parts/content','archive' );
				endwhile;
				?>
			</div>
	    </div>
	    <?php wpbeginner_numeric_posts_nav(); ?>
	</div>

</section>

<?php get_footer(); ?>
