<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after
 *
 * @package WordPress
 * @subpackage WPA_Italia_Digitale
 * @since WPA Italia Digitale 2.2
 */
?>

<footer class="u-background-grey-80" itemtype="http://schema.org/WPFooter" itemscope="">
    <div class="u-layout-wide u-layoutCenter u-layout-r-withGutter">
    <div class="Footer u-padding-all-s">

  <div class="u-cf">
    <?php
      if ( get_option('wpaitaliadigitale_footer_logo') != '' )
        echo '<img class="Footer-logo" src="'.get_option('wpaitaliadigitale_footer_logo').'" alt="'.get_bloginfo('name').'" />';
      else
        echo '<img class="Footer-logo" src="'.get_template_directory_uri().'/images/logo-wpa-bianco.png" alt="'.get_bloginfo('name').'" />';
     ?>

    <p class="Footer-siteName">
      <?php echo bloginfo('name'); ?>
    </p>
  </div>

  <div class="Grid Grid--withGutter">
    <?php if ( is_active_sidebar( 'footer-sidebar' ) ) :
    	dynamic_sidebar( 'footer-sidebar' );
    endif; ?>


	<div class="Footer-block Grid-cell"></div>
    
        <?php if ( get_option('wpaitaliadigitale_footer_social_channels')== 'si' && (get_option('wpaitaliadigitale_social_facebook') != '' || get_option('wpaitaliadigitale_social_googleplus') != '' || get_option('wpaitaliadigitale_social_flickr') != '' || get_option('wpaitaliadigitale_social_twitter') != '' || get_option('wpaitaliadigitale_social_youtube') != '')){ 

	        echo '<div class="Footer-otherinfo Grid-cell u-md-size1of2 u-lg-size1of2"><ul class="Footer-socialIcons">';
	          
	          if ( get_option('wpaitaliadigitale_social_facebook') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_facebook').'"><span class="Icon Icon-facebook"></span><span class="u-hiddenVisually">Facebook</span></a></li>';
	          if ( get_option('wpaitaliadigitale_social_twitter') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_twitter').'"><span class="Icon Icon-twitter"></span><span class="u-hiddenVisually">Twitter</span></a></li>';
	          if ( get_option('wpaitaliadigitale_social_youtube') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_youtube').'"><span class="Icon Icon-youtube"></span><span class="u-hiddenVisually">Youtube</span></a></li>';
	          if ( get_option('wpaitaliadigitale_social_googleplus') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_googleplus').'"><span class="Icon Icon-googleplus"></span><span class="u-hiddenVisually">Googleplus</span></a></li>';
	          if ( get_option('wpaitaliadigitale_social_flickr') != '') echo '<li><a href="'.get_option('wpaitaliadigitale_social_youtube').'"><span class="Icon Icon-flickr"></span><span class="u-hiddenVisually">Flickr</span></a></li>';
	          
	        echo '</ul></div>';

		} 
    
	echo '<div class="Footer-otherinfo Footer-copyright Grid-cell ';
	if ( get_option('wpaitaliadigitale_footer_social_channels')== 'si' && (get_option('wpaitaliadigitale_social_facebook') != '' || get_option('wpaitaliadigitale_social_googleplus') != '' || get_option('wpaitaliadigitale_social_flickr') != '' || get_option('wpaitaliadigitale_social_twitter') != '' || get_option('wpaitaliadigitale_social_youtube') != ''))
		echo 'u-md-size1of2 u-lg-size1of2';
	else 
		echo 'u-md-size1of1 u-lg-size1of1';
	
		echo '"><p>Consorzio Z.I.R. Predda Niedda Sassari &copy; Copyright '.date('Y').'</p></div>';
	
	?>

  </div>



</div>

    </div>
</footer>

<a href="#" aria-label="Torna all'inizio del contenuto" title="Torna all'inizio del contenuto" class="ScrollTop js-scrollTop js-scrollTo">
  <span class="ScrollTop-icon Icon-collapse" aria-hidden="true"></span>
  <span class="u-hiddenVisually"><?php echo __('Back to the beginning of the content','wpaitaliadigitale'); ?></span>
</a>

<div id="cookie-bar" class="CookieBar js-CookieBar u-background-95 u-padding-r-all">
  <p class="u-color-white u-text-r-xs u-lineHeight-m u-padding-r-bottom"><?php echo __('This site uses technical, analytics and third-party cookies.','wpaitaliadigitale'); ?>
    <br><?php echo __('If you continue the navigation you accept the use of cookies.','wpaitaliadigitale'); ?><br>
  </p>
  <p>
    <button class="Button Button--default u-text-r-xxs js-cookieBarAccept u-inlineBlock u-margin-r-all"><?php echo __('Accpet','wpaitaliadigitale'); ?></button>
    <?php if ( get_option('wpaitaliadigitale_privacy_policy') != '') { ?><a href="<?php echo get_option('wpaitaliadigitale_privacy_policy'); ?>" target="_blank" class="u-text-r-xs u-color-30"><?php echo __('Privacy Policy','wpaitaliadigitale'); ?></a><?php } ?>
  </p>
</div>
<?php
wp_footer(); ?>
<script type="text/javascript">
(function () {
	$('a#showShareOptions').on( "click touchstart", function(e) {
		e.preventDefault();
		$( this ).addClass('u-hidden');
		$('#shareOptions').removeClass('u-hidden');
	});
	
	$('a#closeShareOptions').on( "click touchstart", function(e) {
		e.preventDefault();
		$( '#showShareOptions' ).removeClass('u-hidden');
		$('#shareOptions').addClass('u-hidden');
	});
}());	 
</script>
</body>
</html>