/**

 * @namespace WPGMZA

 * @module Polygon

 * @requires WPGMZA.MapObject

 */

(function($) {

	WPGMZA.Polygon = function(row, enginePolygon)

	{

		var self = this;

		

		WPGMZA.assertInstanceOf(this, "Polygon");

		

		this.paths = null;

		this.title = null;

		this.name = null;

		this.link = null;

		

		WPGMZA.MapObject.apply(this, arguments);

	}

	

	WPGMZA.Polygon.prototype = Object.create(WPGMZA.MapObject.prototype);

	WPGMZA.Polygon.prototype.constructor = WPGMZA.Polygon;

	

	WPGMZA.Polygon.getConstructor = function()

	{

		switch(WPGMZA.settings.engine)

		{

			case "open-layers":

				if(WPGMZA.isProVersion())

					return WPGMZA.OLProPolygon;

				return WPGMZA.OLPolygon;

				break;

			

			default:

				if(WPGMZA.isProVersion())

					return WPGMZA.GoogleProPolygon;

				return WPGMZA.GooglePolygon;

				break;

		}

	}

	

	WPGMZA.Polygon.createInstance = function(row, engineObject)

	{

		var constructor = WPGMZA.Polygon.getConstructor();

		return new constructor(row, engineObject);

	}

	

	WPGMZA.Polygon.prototype.toJSON = function()

	{

		var result = WPGMZA.MapObject.prototype.toJSON.call(this);

		

		$.extend(result, {

			name:		this.name,

			title:		this.title,

			link:		this.link,

		});

	

		return result;

	}

	

})(jQuery);