<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since WPA Italia Digitale 2.2
 Template Name: Page with Right Sidebar
 */

get_header();
while ( have_posts() ) : the_post(); ?>
<section id="main">
  <div class="u-layout-wide u-layoutCenter u-layout-withGutter u-padding-r-bottom u-padding-top-s">
     <nav aria-label="<?php echo __('You are here','wpaitaliadigitale'); ?>:" >
        <ol class="Breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">
          <?php if(function_exists('bcn_display'))
            {
                bcn_display();
            }?>
        </ol>
    </nav>
  </div>

  <div class="u-layout-wide u-layout-withGutter u-layoutCenter u-padding-r-top u-margin-bottom-l">
    <div id="Section-Contents" class="Grid Grid--withGutter">
	  <div id="Main-Container" class="Grid-cell Grid-AreaTematica Grid-PaginaInterna Prose u-md-size8of12 u-lg-size8of12 u-margin-bottom-l">
		<h1 class="u-text-h2"><?php the_title(); ?></h1>
        <?php the_content(); ?>
      </div>
	  <aside id="Right-Sidebar" class="Grid-cell Grid-Sidebar u-sizeFull u-md-size4of12 u-lg-size4of12 u-margin-bottom-l" itemscope itemtype="http://schema.org/WPSideBar">
		  <?php 
			$sidebar_select = get_post_meta (get_the_ID(), "custom-sidebar-number", true );
			if( $sidebar_select !="" && is_active_sidebar( $sidebar_select )) : 
				dynamic_sidebar( $sidebar_select ); 
			endif;
			
		?>
	    </aside>
    </div>
</div>
</section>
<?php endwhile;
get_footer(); ?>
