<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since WPA Italia Digitale 2.2
       Template Name: Press
 */

get_header();
while ( have_posts() ) : the_post(); ?>
<section id="main">
  <div class="u-layout-wide u-layoutCenter u-layout-withGutter u-padding-r-bottom u-padding-top-s">
      <nav aria-label="<?php echo __('You are here','wpaitaliadigitale'); ?>:" >
        <ol class="Breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">
          <?php if(function_exists('bcn_display'))
            {
                bcn_display();
            }?>
        </ol>
    </nav>
  </div>

  <div class="u-layout-wide u-layout-withGutter u-layoutCenter u-padding-r-top u-margin-bottom-l">
    <h1 class="u-text-h2"><?php the_title(); ?></h1>
    <div class="Grid Grid--withGutter">
        <div class="Grid-cell Grid-AreaTematica Grid-PaginaInterna u-md-size12of12 u-lg-size12of12 ">
          <?php
            $day = ''; $count=0;
            $query = new WP_Query( array('posts_per_page'=>-1,'post_type' => 'press' ));

            if($query->have_posts()) :

               while ( $query->have_posts() ) :
                  $query->the_post();


                  if ($day != get_the_date()) {
                    if($count>0)  echo '</article>'; else $count++;
                    echo '<article class="Prose u-layout-release u-margin-bottom-xl"><h2 class="u-text-h3 u-color-40 u-margin-bottom-s">'.get_the_date('l j F Y').'</h2>';
                    $day=get_the_date();
                  }
                  ?>
                  <table class="Table Table--flip Table--nomargin u-text-r-m">
                      <thead style="width: 20%;min-width: 20%">
                          <tr class="u-layout-prose " style="width: 100%;min-width: 100%">
                              <th>
                                 <?php the_title(); ?>
                              </th>
                          </tr>
                        </thead>
                        <tbody style="width: 80%;min-width: 80%">
                            <tr class="u-layout-prose " style="width: 30%;min-width: 30%">
                                <?php
								echo '<td><a href="'.types_render_field('file-attachment', array('raw' => 'true')).'" target="_blank">';
                                

                                if(pathinfo(types_render_field('file-attachment', array('raw' => 'true')), PATHINFO_EXTENSION)=='pdf')
                                    echo '<span class="u-text-r-l Icon Icon-pdf u-text-color-black"></span> '.pathinfo(types_render_field('file-attachment', array('raw' => 'true')), PATHINFO_BASENAME);
                                else if(pathinfo(types_render_field('file-attachment', array('raw' => 'true')), PATHINFO_EXTENSION)=='doc' || pathinfo(types_render_field('file-attachment', array('raw' => 'true')), PATHINFO_EXTENSION)=='docx')
                                    echo '<span class="u-text-r-l Icon Icon-file u-text-color-black"></span> '.pathinfo(types_render_field('file-attachment', array('raw' => 'true')), PATHINFO_BASENAME);
                                else
                                    echo '<span class="u-text-r-l Icon Icon-copy u-text-color-black"></span> '.pathinfo(types_render_field('file-attachment', array('raw' => 'true')), PATHINFO_BASENAME);
                                 ?>
                                </a></td>
                            </tr>
                            <tr class="u-layout-prose u-sizeFull u-text-r-xxs" style="width: 70%;min-width: 70%">
                                <td><?php the_content(); ?></td>
                            </tr>
                        </tbody>
                  </table>
                  <?php
                endwhile;
                echo '</article>';
            endif;

            wp_reset_postdata();


           ?>
        </div>
    </div>
</div>
</section>
<?php endwhile;
get_footer(); ?>
