<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since WPA Italia Digitale 2.2
 Template Name: Contacts
 */

get_header();
while ( have_posts() ) : the_post(); ?>
<section id="main">
  <div class="u-layout-wide u-layoutCenter u-layout-withGutter u-padding-r-bottom u-padding-top-s">
		<nav aria-label="<?php echo __('You are here','wpaitaliadigitale'); ?>:" >
	        <ol class="Breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">
	          <?php if(function_exists('bcn_display'))
	            {
	                bcn_display();
	            }?>
	        </ol>
	    </nav>
	</div>

	  <div class="u-layout-wide u-layout-withGutter u-layoutCenter u-padding-r-top u-margin-bottom-l">
	    <h1 class="u-text-h2"><?php the_title(); ?></h1>
	    <div class="Grid Grid--withGutter">
	      <?php 
		  if(get_option('wpaitaliadigitale_maps_api_key') != '' && get_option('wpaitaliadigitale_maps_latitude') != '' && get_option('wpaitaliadigitale_maps_longitude') != '')
			  echo '<div class="Grid-cell u-md-size1of2 u-lg-size1of2 u-margin-bottom-l">';
		  else
			  echo '<div class="Grid-cell u-md-size2of2 u-lg-size2of2 u-margin-bottom-l">';
		  ?>
	        <div class="u-cf u-padding-bottom-xxl">
	          <?php the_content();

			          echo '<h2 class="u-text-h3 u-margin-top-l">'.__('Details','wpaitaliadigitale').':</h2><ul class="Grid">';

			          	if ( get_option('wpaitaliadigitale_footer_indirizzo1') != '' ){
			              echo '<li class="Grid-cell u-size2of2 u-margin-top-s">
			                <span class="u-text-r-m u-color-40 Icon Icon-indirizzo" > </span>
			                <span class="u-text-r-m" >'.__('Address','wpaitaliadigitale').': '.get_option('wpaitaliadigitale_footer_indirizzo1').'</span>
			              </li>';
			            }


			            if ( get_option('wpaitaliadigitale_footer_telefono1') != '' ){
			              echo '<li class="Grid-cell u-size2of2 u-margin-top-s">
			                <span class="u-text-r-m u-color-40 Icon Icon-telefono" > </span>
			                <span class="u-text-r-m" >'.__('Phone','wpaitaliadigitale').': '.get_option('wpaitaliadigitale_footer_telefono1').'</span>
			              </li>';
			            }

			            if ( get_option('wpaitaliadigitale_footer_fax1') != '' ){
			              echo '<li class="Grid-cell u-size2of2 u-margin-top-s">
			                <span class="u-text-r-m u-color-40 Icon Icon-fax" > </span>
			                <span class="u-text-r-m" >'.__('Fax','wpaitaliadigitale').': '.get_option('wpaitaliadigitale_footer_fax1').'</span>
			              </li>';
			            }


			            if ( get_option('wpaitaliadigitale_email_pec') != '' ){
			              echo '<li class="Grid-cell u-size2of2 u-margin-top-s">
			                <span class="u-text-r-m u-color-40 Icon Icon-mail" > </span>
			                <span class="u-text-r-m" >'.__('Email PEC','wpaitaliadigitale').': '.get_option('wpaitaliadigitale_email_pec').'</span>
			              </li>';
			            }

			            if ( get_option('wpaitaliadigitale_vat') != '' ){
			              echo '<li class="Grid-cell u-size2of2 u-margin-top-s">
			                <span class="u-text-r-m u-color-40 Icon Icon-file" > </span>
			                <span class="u-text-r-m" >'.__('VAT','wpaitaliadigitale').': '.get_option('wpaitaliadigitale_vat').'</span>
			              </li>';
			            }

			          echo '</ul>';
			    ?>
	        </div>


	      </div>
		  <?php if(get_option('wpaitaliadigitale_maps_api_key') != '' && get_option('wpaitaliadigitale_maps_latitude') != '' && get_option('wpaitaliadigitale_maps_longitude') != ''){ ?>
	      <div class="Grid-cell u-sizeFull u-md-size1of2 u-lg-size1of2 u-margin-bottom-l u-padding-left-xl u-padding-right-xl">
	          <div id="map" style="height: 400px;width: 100%;"></div>
			  <script type="text/javascript">
				  function initMap() {
												
					var map = new google.maps.Map(document.getElementById('map'), {
					  zoom: <?php if(get_option('wpaitaliadigitale_maps_zoom')!= '') echo get_option('wpaitaliadigitale_maps_zoom'); else echo '17'; ?>,
					  center: {lat: <?php echo  get_option('wpaitaliadigitale_maps_latitude'); ?>, lng: <?php echo  get_option('wpaitaliadigitale_maps_longitude'); ?>},
					  mapTypeControlOptions: {
						mapTypeIds: ['roadmap', 'satellite']
					  },
					  styles:[
					  {
						"elementType": "geometry",
						"stylers": [
						  {
							"color": "#f5f5f5"
						  }
						]
					  },
					  {
						"elementType": "labels.icon",
						"stylers": [
						  {
							"visibility": "off"
						  }
						]
					  },
					  {
						"elementType": "labels.text.fill",
						"stylers": [
						  {
							"color": "#616161"
						  }
						]
					  },
					  {
						"elementType": "labels.text.stroke",
						"stylers": [
						  {
							"color": "#f5f5f5"
						  }
						]
					  },
					  {
						"featureType": "administrative.land_parcel",
						"elementType": "labels.text.fill",
						"stylers": [
						  {
							"color": "#bdbdbd"
						  }
						]
					  },
					  {
						"featureType": "poi",
						"elementType": "geometry",
						"stylers": [
						  {
							"color": "#eeeeee"
						  }
						]
					  },
					  {
						"featureType": "poi",
						"elementType": "labels.text.fill",
						"stylers": [
						  {
							"color": "#757575"
						  }
						]
					  },
					  {
						"featureType": "poi.park",
						"elementType": "geometry",
						"stylers": [
						  {
							"color": "#e5e5e5"
						  }
						]
					  },
					  {
						"featureType": "poi.park",
						"elementType": "labels.text.fill",
						"stylers": [
						  {
							"color": "#9e9e9e"
						  }
						]
					  },
					  {
						"featureType": "road",
						"elementType": "geometry",
						"stylers": [
						  {
							"color": "#ffffff"
						  }
						]
					  },
					  {
						"featureType": "road.arterial",
						"elementType": "labels.text.fill",
						"stylers": [
						  {
							"color": "#757575"
						  }
						]
					  },
					  {
						"featureType": "road.highway",
						"elementType": "geometry",
						"stylers": [
						  {
							"color": "#dadada"
						  }
						]
					  },
					  {
						"featureType": "road.highway",
						"elementType": "labels.text.fill",
						"stylers": [
						  {
							"color": "#616161"
						  }
						]
					  },
					  {
						"featureType": "road.local",
						"elementType": "labels.text.fill",
						"stylers": [
						  {
							"color": "#9e9e9e"
						  }
						]
					  },
					  {
						"featureType": "transit.line",
						"elementType": "geometry",
						"stylers": [
						  {
							"color": "#e5e5e5"
						  }
						]
					  },
					  {
						"featureType": "transit.station",
						"elementType": "geometry",
						"stylers": [
						  {
							"color": "#eeeeee"
						  }
						]
					  },
					  {
						"featureType": "water",
						"elementType": "geometry",
						"stylers": [
						  {
							"color": "#c9c9c9"
						  }
						]
					  },
					  {
						"featureType": "water",
						"elementType": "labels.text.fill",
						"stylers": [
						  {
							"color": "#9e9e9e"
						  }
						]
					  }
					]

					});

					var image = '<?php echo get_template_directory_uri(); ?>/images/pin-map.svg';
					var beachMarker = new google.maps.Marker({
					  position: {lat: <?php echo  get_option('wpaitaliadigitale_maps_latitude'); ?>, lng: <?php echo  get_option('wpaitaliadigitale_maps_longitude'); ?>},
					  map: map,
					  icon: image
					});
					

				  }
				</script>
				<script async defer src="https://maps.googleapis.com/maps/api/js?key=<?php echo get_option('wpaitaliadigitale_maps_api_key'); ?>&callback=initMap"></script>
		  </div>
		  <?php } ?>

	      <div class="Grid-cell u-sizeFull u-md-size2of2 u-lg-size2of2 u-margin-bottom-l">
	        <h3 class="u-text-h3 "><?php echo __('Write us','wpaitaliadigitale'); ?>:</h3>
				<div class="Form Form--spaced u-padding-all-l u-background-grey-30 u-text-r-xs u-layout-release">
				  <div class="Prose Alert Alert--info">
				    <p><?php echo __('All fields are required unless indicated','wpaitaliadigitale'); ?></p>
				  </div>
					<?php echo do_shortcode('[contact-form-7 id="99" title="Contattaci"]');  ?>
				</div>
	      </div>
	    </div>
	</div>
</section>
<?php endwhile;
get_footer(); ?>
