<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since WPA Italia Digitale 2.2
Template Name: Blog
 */

get_header();
while ( have_posts() ) : the_post(); ?>
<section id="main">
  <div class="u-layout-wide u-layoutCenter u-layout-withGutter u-padding-r-bottom u-padding-top-s">
      <nav aria-label="<?php echo __('You are here','wpaitaliadigitale'); ?>:" >
        <ol class="Breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">
          <?php if(function_exists('bcn_display'))
            {
                bcn_display();
            }?>
        </ol>
    </nav>
  </div>

<div class="u-layout-wide u-layout-withGutter u-layoutCenter u-padding-r-top u-margin-bottom-l">
  <h1 class="u-text-h2"><?php the_title(); ?></h1>
  <div class=" u-layout-centerContent u-cf">
      <div class="js-Masonry-container u-layout-large" data-columns="2">
        <?php
        global $paged, $query;
		$curpage = $paged ? $paged : 1;

		$args = array(
			'post_type' => 'post',
			'orderby' => 'post_date',
			'posts_per_page' => 6,
			'paged' => $paged
		);
		$query = new WP_Query($args);
		if($query->have_posts()) : while ($query->have_posts()) : $query->the_post();

				get_template_part( 'template-parts/content','archive' );

		endwhile; ?>

		 </div>
    </div>
    <?php

		if($query->max_num_pages>1){

			$paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
			$max   = intval( $query->max_num_pages );

			if ( $paged >= 1 )
				$links[] = $paged;

			if ( $paged >= 3 ) {
				$links[] = $paged - 1;
				$links[] = $paged - 2;
			}

			if ( ( $paged + 2 ) <= $max ) {
				$links[] = $paged + 2;
				$links[] = $paged + 1;
			}


			echo '<nav aria-label="'.__('Pagination','wpaitaliadigitale').'"><ul class="Pagination">';
			if($curpage-1 > 0)
				echo '<li class="Page-item"><a rel="prev" class="Page-link Page-link--prev" href="'.get_pagenum_link(($curpage-1 > 0 ? $curpage-1 : 1)).'" aria-label="Precedente"><span class="u-text-r-s Icon Icon-chevron-left"></span><span class="u-hidden">Precedente</span></a></li>';


			if ( ! in_array( 1, $links ) ) {
				$class = 1 == $paged ? ' class="Page-item active"' : 'class="Page-item"';
				$rel = 1 == $paged ? ' rel="canonical" ' : '';
				printf( '<li %s><a class="Page-link" %s href="%s">%s</a></li>' . "\n", $class, $rel, esc_url( get_pagenum_link( 1 ) ), '1' );

				if ( ! in_array( 2, $links ) )
					echo '<li class="Page-item Page-item--puntini">...</li>';
			}


			sort( $links );
			foreach ( (array) $links as $link ) {
				$class = $paged == $link ? ' class="Page-item active"' : 'class="Page-item"';
				$rel = $paged == $link ? ' rel="canonical" ' : '';
				printf( '<li %s><a class="Page-link" %s href="%s">%s</a></li>' . "\n",$class, $rel, esc_url( get_pagenum_link( $link ) ), $link );
			}

			if ( ! in_array( $max, $links ) ) {
				if ( ! in_array( $max - 1, $links ) )
					echo '<li class="Page-item Page-item--puntini">...</li>' . "\n";

				$class = $paged == $max ? ' class="Page-item active"' : 'class="Page-item"';
				$rel = $paged == $max ? ' rel="canonical" ' : '';
				printf( '<li %s><a class="Page-link" %s href="%s">%s</a></li>' . "\n", $class, $rel, esc_url( get_pagenum_link( $max ) ), $max );
			}


			if($curpage<$query->max_num_pages)
				echo '<li class="Page-item"><a class="Page-link Page-link--next" rel="next" href="'.get_pagenum_link(($curpage+1 <= $query->max_num_pages ? $curpage+1 : $query->max_num_pages)).'" aria-label="Successiva"><span class="u-text-r-s Icon Icon-chevron-right"></span><span class="u-hidden">Successiva</span></a></li>';
			echo '</ul></nav>';
		}
		wp_reset_postdata();

		endif;
	?>
</div>




</section>
<?php endwhile;
get_footer(); ?>
