<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since WPA Italia Digitale 2.2
 Template Name: Page Amministrazione Trasparente
 */

get_header();
while ( have_posts() ) : the_post(); ?>
<section id="main">
  <div class="u-layout-wide u-layoutCenter u-layout-withGutter u-padding-r-bottom u-padding-top-s">
      <nav aria-label="<?php echo __('You are here','wpaitaliadigitale'); ?>:" >
        <ol class="Breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">
          <?php if(function_exists('bcn_display'))
            {
                bcn_display();
            }?>
        </ol>
    </nav>
  </div>

  <div class="u-layout-wide u-layout-withGutter u-layoutCenter u-padding-r-top u-margin-bottom-l">
    <h1 class="u-text-h2"><?php the_title(); ?></h1>
    <div class="Grid Grid--withGutter">
      <div class="Grid-cell u-md-size8of12 u-lg-size8of12 u-margin-bottom-l">
        <article class="Grid-cell u-md-size11of12 u-lg-size11of12">

            <div class="Grid-cell Prose u-layout-release u-color-black u-margin-bottom-m u-margin-top-m">
              <?php the_content(); ?>
            </div>

        </article>
      </div>
     <?php endwhile; ?>
      <aside class="Grid-cell Grid-Sidebar u-sizeFull u-md-size4of12 u-lg-size4of12 u-margin-bottom-l" itemscope itemtype="http://schema.org/WPSideBar">
        <?php if ( is_active_sidebar( 'trasparenza-sidebar' ) ) :
          dynamic_sidebar( 'trasparenza-sidebar' );
        endif; ?>
      </aside>
    </div>
</div>
</section>
<?php get_footer(); ?>
