<?php
/**
 * WPA Italia Digitale functions and definitions
 *
 * @package WordPress
 * @subpackage WPA_Italia_Digitale
 * @since WPA Italia Digitale 2.2
 */
show_admin_bar( false );
remove_action( 'wp_head', 'wp_generator' ) ;
remove_action( 'wp_head', 'wlwmanifest_link' ) ;
remove_action( 'wp_head', 'rss_link' ) ;
add_filter( 'pre_comment_content', 'wp_specialchars' );
function complete_version_removal() {
    return '';
}
add_filter('the_generator', 'complete_version_removal');

add_filter('redirect_canonical', 'stop_guessing');
function stop_guessing($url) {
 if (is_404()) {
   return false;
 }
 return $url;
}

// custom options panel
require_once( 'wptuts-upload/wptuts-options.php' );

function wptuts_options_enqueue_scripts() {

    if ( 'toplevel_page_settings' == get_current_screen() -> id ) {
        wp_enqueue_script('jquery');
		wp_enqueue_media();

        wp_enqueue_script('thickbox');
        wp_enqueue_style('thickbox');

        wp_enqueue_script('media-upload');
        wp_enqueue_script('wptuts-upload');

    }

}
add_action('admin_enqueue_scripts', 'wptuts_options_enqueue_scripts');


function custom_admin_footer() {
    echo 'WPA Italia Digitale &copy;2017';
}
add_filter('admin_footer_text', 'custom_admin_footer');


if ( ! function_exists( 'wpaitaliadigitale_setup' ) ) :
function wpaitaliadigitale_setup() {
	load_theme_textdomain( 'wpaitaliadigitale', get_template_directory() . '/languages' );
	$locale = get_locale();
	$locale_file = get_template_directory() . "/languages/$locale.php";
	if ( is_readable($locale_file) ) require_once($locale_file);

	add_theme_support( 'automatic-feed-links' );

	add_theme_support( 'post-thumbnails' );

	register_nav_menus( array(
		'primary-menu' => 'Primary Menu',
		'footer-menu' => 'Footer Menu',
		'trasparenza-menu' => 'Trasparenza Menu',
		'services-menu' => 'Services Menu',
		'institutions-menu' => 'Institutions Menu'
	) );
}
endif;
add_action( 'after_setup_theme', 'wpaitaliadigitale_setup' );

//remove all classes in wordpress menu except the ones selected
add_filter('nav_menu_css_class', 'my_css_attributes_filter', 100, 1);
add_filter('nav_menu_item_id', 'my_css_attributes_filter', 100, 1);
add_filter('page_css_class', 'my_css_attributes_filter', 100, 1);
function my_css_attributes_filter($var) {
  return is_array($var) ? array_intersect($var, array('current-menu-item','menu-item-has-children')) : '';
}


function my_search_form( $form ) {
	$form= '<form role="search" method="get" class="Form search-form" action="' . home_url( '/' ) . '">
		  <div class="Form-field Form-field--withPlaceholder Grid">
		    <input class="Form-input Grid-cell u-sizeFill u-text-r-s" id="s" value="' . get_search_query() . '" name="s" title="Cerca" required="required" aria-required="true">
		    <label class="Form-label" for="s">Cerca...</label>
		    <button class="Grid-cell u-sizeFit Icon-search u-background-60 u-color-white u-padding-all-s u-textWeight-700"
		      title="Avvia la ricerca" aria-label="Avvia la ricerca">
		    </button>
		  </div>
		</form>';

    return $form;
}

add_filter( 'get_search_form', 'my_search_form' );



function enqueue_my_styles() {
	global $wp_styles;
	if (!is_admin()) {
		wp_enqueue_style( 'my-theme', get_stylesheet_uri() );

		wp_enqueue_style( 'vendor', get_template_directory_uri().'/css/vendor.css', array( 'my-theme' ), '', 'screen' );

		if ( get_option('wpaitaliadigitale_main_color') != '' )
			wp_enqueue_style( 'maincolor', get_template_directory_uri().'/css/'.get_option('wpaitaliadigitale_main_color').'.css', array( 'my-theme','vendor' ), '', 'screen' );
		else
			wp_enqueue_style( 'maincolor', get_template_directory_uri().'/css/red.css', array( 'my-theme','vendor' ), '', 'screen' );
	}
}
add_action( 'wp_enqueue_scripts', 'enqueue_my_styles' );


function enqueue_my_scripts() {
	global $wp_scripts;
	if (!is_admin()) {

		wp_deregister_script('jquery');
		wp_register_script('jquery', get_template_directory_uri().'/js/vendor/jquery.min.js', false, '', true);
		wp_enqueue_script('jquery');

		wp_register_script('modernizr-js', get_template_directory_uri().'/js/vendor/modernizr.js',array(),'', false);
		wp_enqueue_script('modernizr-js');
		wp_register_script('IWT-js', get_template_directory_uri().'/js/IWT.min.js',array('jquery'),'', true);
		wp_enqueue_script('IWT-js');

		wp_enqueue_script( 'polyfill-js', get_template_directory_uri() . '/js/vendor/polyfill.min.js', array('jquery'),'', true);
		wp_script_add_data( 'polyfill-js', 'conditional', 'lte IE 9' );

		wp_enqueue_script( 'respond-js', get_template_directory_uri() . '/js/vendor/respond.min.js', array('jquery'),'', true);
		wp_script_add_data( 'respond-js', 'conditional', 'lte IE 8' );

		wp_enqueue_script( 'rem-js', get_template_directory_uri() . '/js/vendor/rem.min.js', array('jquery'),'', true);
		wp_script_add_data( 'rem-js', 'conditional', 'lte IE 8' );

		wp_enqueue_script( 'selectivizr-js', get_template_directory_uri() . '/js/vendor/selectivizr.js', array('jquery'),'', true);
		wp_script_add_data( 'selectivizr-js', 'conditional', 'lte IE 8' );

		wp_enqueue_script( 'slice-js', get_template_directory_uri() . '/js/vendor/slice.js', array('jquery'),'', true);
		wp_script_add_data( 'slice-js', 'conditional', 'lte IE 8' );

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}

	}
}
add_action( 'wp_enqueue_scripts', 'enqueue_my_scripts' );

remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'wp_print_styles', 'print_emoji_styles' );

function remove_cssjs_ver( $src ) {
    if( strpos( $src, '?ver=' ) )
        $src = remove_query_arg( 'ver', $src );
    return $src;
}
add_filter( 'style_loader_src', 'remove_cssjs_ver', 10, 2 );
add_filter( 'script_loader_src', 'remove_cssjs_ver', 10, 2 );



function my_login_logo_url() {
    return home_url();
}
add_filter( 'login_headerurl', 'my_login_logo_url' );

function my_login_logo_url_title() {
    return 'WPA Italia Digitale';
}
add_filter( 'login_headertitle', 'my_login_logo_url_title' );

function my_login_stylesheet() {
    wp_enqueue_style( 'custom-login', get_template_directory_uri() . '/css/style-login.css' );
}
add_action( 'login_enqueue_scripts', 'my_login_stylesheet' );



add_filter( 'get_image_tag', 'remove_width_and_height_attribute', 10 );
add_filter( 'post_thumbnail_html', 'remove_width_and_height_attribute', 10 );
add_filter( 'image_send_to_editor', 'remove_width_and_height_attribute', 10 );

function remove_width_and_height_attribute( $html ) {
   return preg_replace( '/(height|width)="\d*"\s/', "", $html );
}




//numeric pagination
function wpbeginner_numeric_posts_nav() {

	if( is_singular() )
		return;

	global $wp_query;

	if( $wp_query->max_num_pages <= 1 )
		return;

	$paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
	$curpage = $paged ? $paged : 1;
	$max   = intval( $wp_query->max_num_pages );

	if ( $paged >= 1 )
		$links[] = $paged;

	if ( $paged >= 3 ) {
		$links[] = $paged - 1;
		$links[] = $paged - 2;
	}

	if ( ( $paged + 2 ) <= $max ) {
		$links[] = $paged + 2;
		$links[] = $paged + 1;
	}

	echo '<nav aria-label="'.__('Pagination','wpaitaliadigitale').'"><ul class="Pagination">'. "\n";

	if($curpage-1 > 0)
		echo '<li class="Page-item"><a rel="prev" class="Page-link Page-link--prev" href="'.get_pagenum_link(($curpage-1 > 0 ? $curpage-1 : 1)).'" aria-label="Precedente"><span class="u-text-r-s Icon Icon-chevron-left"></span><span class="u-hidden">Precedente</span></a></li>';

	if ( ! in_array( 1, $links ) ) {
		$class = 1 == $paged ? ' class="Page-item active"' : 'class="Page-item"';
		$rel = 1 == $paged ? ' rel="canonical" ' : '';
		printf( '<li %s><a class="Page-link" %s href="%s">%s</a></li>' . "\n", $class, $rel, esc_url( get_pagenum_link( 1 ) ), '1' );

		if ( ! in_array( 2, $links ) )
			echo '<li class="Page-item Page-item--puntini">...</li>';
	}

	sort( $links );
	foreach ( (array) $links as $link ) {
		$class = $paged == $link ? ' class="Page-item active"' : 'class="Page-item"';
		$rel = $paged == $link ? ' rel="canonical" ' : '';
		printf( '<li %s><a class="Page-link" %s href="%s">%s</a></li>' . "\n",$class, $rel, esc_url( get_pagenum_link( $link ) ), $link );
	}

	if ( ! in_array( $max, $links ) ) {
		if ( ! in_array( $max - 1, $links ) )
			echo '<li class="Page-item Page-item--puntini">...</li>' . "\n";

		$class = $paged == $max ? ' class="Page-item active"' : 'class="Page-item"';
		$rel = $paged == $max ? ' rel="canonical" ' : '';
		printf( '<li %s><a class="Page-link" %s href="%s">%s</a></li>' . "\n", $class, $rel, esc_url( get_pagenum_link( $max ) ), $max );
	}


	if($curpage<$query->max_num_pages)
		echo '<li class="Page-item"><a class="Page-link Page-link--next" rel="next" href="'.get_pagenum_link(($curpage+1 <= $query->max_num_pages ? $curpage+1 : $query->max_num_pages)).'" aria-label="Successiva"><span class="u-text-r-s Icon Icon-chevron-right"></span><span class="u-hidden">Successiva</span></a></li>';


	echo '</ul></nav>'."\n";

}


// metabox in pages to select custom sidebar
add_action("admin_init", "sidebar_init");
add_action('save_post', 'save_sidebar_link');
function sidebar_init(){
	add_meta_box("sidebar_meta", "Sidebar Selection", "sidebar_link", "page", "side", "default");
}
function sidebar_link(){
	global $post;
	$dynamic_widget_areas = array();
			
	if(get_option('wpaitaliadigitale_number_custom_sidebars') > 0){
				
		$custom  = get_post_custom($post->ID);
		$link    = $custom["custom-sidebar-number"][0];
		?>
		<p>Select sidebar to use on this page.</p>
		<div class="link_header">
			<?php
			echo '<select name="link" class="sidebar-selection">';
			echo '<option value="0">None</option>';
			//aggiungo anche quella delle news
			if('newspress-sidebar' == $link)
				echo '<option value="newspress-sidebar" selected="true">News-Press Sidebar</option>';
			else
				echo '<option value="newspress-sidebar">News-Press Sidebar</option>';
			
			
			for($i=1; $i <= get_option('wpaitaliadigitale_number_custom_sidebars'); $i++){
				if('custom-sidebar-'.$i == $link){
				  echo '<option value="custom-sidebar-'.$i.'" selected="true">Custom Sidebar '.$i.'</option>';
					}else{
				  echo '<option value="custom-sidebar-'.$i.'">Custom Sidebar'.$i.'</option>';
					}
			}
			echo '</select><br />';
			?>
		</div>
		<?php
	}
}
function save_sidebar_link(){
global $post;
if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {return $post->ID;}
        update_post_meta($post->ID, "custom-sidebar-number", $_POST["link"]);
}
add_action('admin_head', 'sidebar_css');
function sidebar_css() {
        echo'
        <style type="text/css">
                .sidebar-selection{width:100%;}
        </style>
        ';
}


// sidebars
if ( function_exists('register_sidebar') ) {
	
	register_sidebar(array(
    	'name'=>'Header Sidebar',
        'id'=>'header-sidebar',
        'before_widget' => '',
        'after_widget' => '',
        'before_title' => '<span class="u-text-h4">',
        'after_title' => '</span>',
    ));
	
	
    register_sidebar(array(
    	'name'=>'News-Press Sidebar',
        'id'=>'newspress-sidebar',
        'before_widget' => '<div class="Linklist Linklist--padded Treeview Treeview--default js-fr-treeview u-text-r-xs"><div class="u-sizeFull u-md-size11of12 u-lg-size11of12 u-margin-bottom-l" >',
        'after_widget' => '</div></div>',
        'before_title' => '<h4 class="u-text-h3">',
        'after_title' => '</h4>',
    ));

    register_sidebar(array(
    	'name'=>'Partners Sidebar',
        'id'=>'partners-sidebar',
        'before_widget' => '<div class="Grid-cell Grid--Banner u-sm-size1of4 u-md-size1of4 u-md-size2of4  u-lg-size2of4 u-margin-bottom-s">',
        'after_widget' => '</div>',
        'before_title' => '<span class="u-hidden">',
        'after_title' => '</span>',
    ));

    register_sidebar(array(
    	'name'=>'Trasparenza Sidebar',
        'id'=>'trasparenza-sidebar',
        'before_widget' => '<div class="Linklist Linklist--padded Treeview Treeview--default js-fr-treeview u-text-r-xs"><div class="u-sizeFull u-md-size11of12 u-lg-size11of12 u-margin-bottom-l" >',
        'after_widget' => '</div></div>',
        'before_title' => '<h4 class="u-text-h3">',
        'after_title' => '</h4>',
    ));
	
	if(get_option('wpaitaliadigitale_number_custom_sidebars') > 0){
		for($i=1; $i <= get_option('wpaitaliadigitale_number_custom_sidebars'); $i++){
			register_sidebar(array(
				'name'=>'Custom Sidebar '.$i,
				'id'=>'custom-sidebar-'.$i,
				'before_widget' => '<div class="Linklist Linklist--padded u-layout-prose u-text-r-xs"><div class="u-sizeFull u-md-size11of12 u-lg-size11of12 u-margin-bottom-l" >',
				'after_widget' => '</div></div>',
				'before_title' => '<h4 class="u-text-h3">',
				'after_title' => '</h4>',
			));
		}
	}

}


function sidebar_widget_init()
{
	global $_wp_sidebars_widgets;
	if ( empty( $_wp_sidebars_widgets ) ) :
		$_wp_sidebars_widgets = get_option( 'sidebars_widgets', array() );
	endif;

	$sidebars_widgets_count = $_wp_sidebars_widgets;
	$sidebar_count = count( $sidebars_widgets_count[ 'footer-sidebar' ] );

	$sidebar_class = '';
	
	if($sidebar_count > 1){
		if($sidebar_count == 2){
			$sidebar_class = 'u-md-size1of2 u-lg-size1of2';
		} elseif($sidebar_count == 3){
			$sidebar_class = 'u-sm-size1of2 u-md-size1of3 u-lg-size1of3';
		} elseif($sidebar_count == 4){
			$sidebar_class = 'u-sm-size2of4 u-md-size1of4 u-lg-size1of4';
		}else{
			$sidebar_class = 'u-sm-size2of4 u-md-size1of4 u-lg-size1of4';
		}
	}

	
	register_sidebar(array(
    	'name'=>'Footer Sidebar',
        'id'=>'footer-sidebar',
        'before_widget' => '<div class="Footer-block Grid-cell '.$sidebar_class.'">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="Footer-blockTitle u-text-h2">',
        'after_title' => '</h4>',
    ));
}
add_action('widgets_init','sidebar_widget_init');
	

add_theme_support( 'html5', array(
	'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
) );

add_theme_support( 'post-formats', array(
	'image', 'video', 'gallery'
) );

if ( ! function_exists( 'wpaitaliadigitale_comment_nav' ) ) :
	function wpaitaliadigitale_comment_nav() {
		if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
		?>
		<nav class="navigation comment-navigation" role="navigation">
			<h2 class="screen-reader-text"><?php _e( 'Comment navigation', 'wpaitaliadigitale' ); ?></h2>
			<div class="nav-links">
				<?php
					if ( $prev_link = get_previous_comments_link( __( 'Older Comments', 'wpaitaliadigitale' ) ) ) :
						printf( '<div class="nav-previous">%s</div>', $prev_link );
					endif;

					if ( $next_link = get_next_comments_link( __( 'Newer Comments', 'wpaitaliadigitale' ) ) ) :
						printf( '<div class="nav-next">%s</div>', $next_link );
					endif;
				?>
			</div>
		</nav>
		<?php
		endif;
	}
endif;


// required plugins
include 'inc/functions/functions_tgm.php';




// custom post types

function my_custom_post_types() {

	$labels = array(
		'name'                => 'Fotografie' ,
		'singular_name'       => 'Fotografia',
		'menu_name'           => 'Fotografie' ,
		'view_item'           => 'Visualizza Fotografia' ,
		'add_new_item'        => 'Aggiungi nuova Fotografia' ,
		'edit_item'           => 'Modifica Fotografia' ,
		'update_item'         => 'Aggiorna Fotografia' ,
		'search_items'        => 'Cerca Fotografia' 
	);
	
	$args = array(
		'label'               => 'galleria-foto',
		'description'         => '',
		'labels'              => $labels,
		'supports'            => array( 'title', 'editor', 'thumbnail' ),
		'taxonomies'          => array( 'album' ),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'menu_icon' 		  => 'dashicons-format-image',
		'show_in_admin_bar'   => true,
		'menu_position'       => 25,
		'can_export'          => true,
		'has_archive'         => false,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
	);
	
	
	$labels2 = array(
		'name'                => 'Video' ,
		'singular_name'       => 'Video',
		'menu_name'           => 'Video' ,
		'view_item'           => 'Visualizza Video' ,
		'add_new_item'        => 'Aggiungi nuovo Video' ,
		'edit_item'           => 'Modifica Video' ,
		'update_item'         => 'Aggiorna Video' ,
		'search_items'        => 'Cerca Video' 
	);
	
	$args2 = array(
		'label'               => 'galleria-video',
		'description'         => '',
		'labels'              => $labels2,
		'supports'            => array( 'title', 'editor'),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'menu_icon' 		  => 'dashicons-video-alt3',
		'show_in_admin_bar'   => true,
		'menu_position'       => 25,
		'can_export'          => true,
		'has_archive'         => false,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
	);
	
	
	$labels3 = array(
		'name'                => 'Istituzioni' ,
		'singular_name'       => 'Istituzione',
		'menu_name'           => 'Istituzioni' ,
		'view_item'           => 'Visualizza Istituzione' ,
		'add_new_item'        => 'Aggiungi nuova Istituzione' ,
		'edit_item'           => 'Modifica Istituzione' ,
		'update_item'         => 'Aggiorna Istituzione' ,
		'search_items'        => 'Cerca Istituzione' 
	);
	
	$args3 = array(
		'label'               => 'istituzione',
		'description'         => '',
		'labels'              => $labels3,
		'supports'            => array( 'title', 'editor' ),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'menu_icon' 		  => 'dashicons-businessman',
		'show_in_admin_bar'   => true,
		'menu_position'       => 25,
		'can_export'          => true,
		'has_archive'         => false,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
	);
	
	$labels4 = array(
		'name'                => 'Servizi' ,
		'singular_name'       => 'Servizio',
		'menu_name'           => 'Servizi' ,
		'view_item'           => 'Visualizza Servizio' ,
		'add_new_item'        => 'Aggiungi nuova Servizio' ,
		'edit_item'           => 'Modifica Servizio' ,
		'update_item'         => 'Aggiorna Servizio' ,
		'search_items'        => 'Cerca Servizio' 
	);
	
	$args4 = array(
		'label'               => 'servizio',
		'description'         => '',
		'labels'              => $labels4,
		'supports'            => array( 'title', 'editor' ),
		'taxonomies'          => array( 'categoria-servizio' ),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'menu_icon' 		  => 'dashicons-admin-site',
		'show_in_admin_bar'   => true,
		'menu_position'       => 25,
		'can_export'          => true,
		'has_archive'         => false,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
	);
	
	$labels5 = array(
		'name'                => 'Press' ,
		'singular_name'       => 'Press',
		'menu_name'           => 'Press' ,
		'view_item'           => 'Visualizza Press' ,
		'add_new_item'        => 'Aggiungi nuova Press' ,
		'edit_item'           => 'Modifica Press' ,
		'update_item'         => 'Aggiorna Press' ,
		'search_items'        => 'Cerca Press' 
	);
	
	$args5 = array(
		'label'               => 'press',
		'description'         => '',
		'labels'              => $labels5,
		'supports'            => array( 'title', 'editor'),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'menu_icon' 		  => 'dashicons-download',
		'show_in_admin_bar'   => true,
		'menu_position'       => 25,
		'can_export'          => true,
		'has_archive'         => false,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
	);
	
	register_post_type( 'galleria-foto', $args );
	register_post_type( 'galleria-video', $args2 );
	register_post_type( 'istituzione', $args3 );
	register_post_type( 'servizio', $args4 );
	register_post_type( 'press', $args5 );

}

add_action( 'init', 'my_custom_post_types', 0 );



/**
 * Register Multiple Taxonomies
 *
 * @author Bill Erickson
 * @link http://www.billerickson.net/code/register-multiple-taxonomies/
 */
function be_register_taxonomies() {
	$taxonomies = array(
		array(
			'slug'         => 'album',
			'single_name'  => 'Album',
			'plural_name'  => 'Albums',
			'post_type'    => 'galleria-foto',
			'rewrite'      => array( 'slug' => 'album' ),
			'hierarchical' => true
			
		),
		array(
			'slug'         => 'categoria-servizio',
			'single_name'  => 'Categoria Servizi',
			'plural_name'  => 'Categorie Servizi',
			'post_type'    => 'servizio',
			'hierarchical' => true
		)
	);
	foreach( $taxonomies as $taxonomy ) {
		$labels = array(
			'name' => $taxonomy['plural_name'],
			'singular_name' => $taxonomy['single_name'],
			'search_items' =>  'Search ' . $taxonomy['plural_name'],
			'all_items' => 'All ' . $taxonomy['plural_name'],
			'parent_item' => 'Parent ' . $taxonomy['single_name'],
			'parent_item_colon' => 'Parent ' . $taxonomy['single_name'] . ':',
			'edit_item' => 'Edit ' . $taxonomy['single_name'],
			'update_item' => 'Update ' . $taxonomy['single_name'],
			'add_new_item' => 'Add New ' . $taxonomy['single_name'],
			'new_item_name' => 'New ' . $taxonomy['single_name'] . ' Name',
			'menu_name' => $taxonomy['plural_name']
		);
		
		$rewrite = isset( $taxonomy['rewrite'] ) ? $taxonomy['rewrite'] : array( 'slug' => $taxonomy['slug'] );
		$hierarchical = isset( $taxonomy['hierarchical'] ) ? $taxonomy['hierarchical'] : true;
	
		register_taxonomy( $taxonomy['slug'], $taxonomy['post_type'], array(
			'hierarchical' => $hierarchical,
			'labels' => $labels,
			'show_ui' => true,
			'query_var' => true,
			'show_admin_column' => true,
			'show_in_menu' =>true,
			'rewrite' => $rewrite,
		));
	}
	
}
add_action( 'init', 'be_register_taxonomies' );