<?php
/**
 * The template for displaying archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each one. For example, tag.php (Tag archives),
 * category.php (Category archives), author.php (Author archives), etc.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Sixteen
 * @since WPA Italia Digitale 2.2
 */

get_header(); ?>
<section id="main">
	<div class="u-layout-wide u-layoutCenter u-layout-withGutter u-padding-r-bottom u-padding-top-s">
	      <nav aria-label="<?php echo __('You are here','wpaitaliadigitale'); ?>:" >
	        <ol class="Breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">
	          <?php if(function_exists('bcn_display'))
	            {
	                bcn_display();
	            }?>
	        </ol>
	    </nav>
	</div>

	<div class="u-layout-wide u-layout-withGutter u-layoutCenter u-padding-r-top u-margin-bottom-l">
	  <h1 class="u-text-h2">
		<?php
			
			$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
			if(get_the_title()!='') echo $term->name;
		 ?>
	  </h1>
	  <div class="Grid Grid--withGutter">
		<div class="Grid-cell u-md-size8of12 u-lg-size8of12 u-margin-bottom-l">
			  <div class=" u-layout-centerContent u-cf">
				  <div class="js-Masonry-container u-layout-large" data-columns>
						<?php
						if(have_posts()) :
						while ( have_posts() ) : the_post();
							echo '<article class="Masonry-item js-Masonry-item">
							  <div class="Card Card--shadow Card--round u-background-white">';
								if(get_the_post_thumbnail($post->ID, 'full')!='')
								  echo '<div class="Card-image"><a href="'.get_the_permalink().'">'.get_the_post_thumbnail(get_the_ID(), 'full',array('class' => 'u-sizeFull')).'</a></div>';

							   echo '<div class="Card-content">
							  <h2 class="u-margin-r-bottom"><a class="u-text-h4 u-textClean u-color-black" href="'.get_the_permalink().'">
								'.get_the_title().'
								</a>
							  </h2><p>
							  '.get_the_excerpt().'</p>
							</div>


							  </div>
							</article>';
						endwhile;
						else:
							echo '<p>'.__('No documents found','wpaitaliadigitale').'.</p>';
						endif;
						?>
					</div>
				</div>
			<?php wpbeginner_numeric_posts_nav(); ?>
		</div>
		<aside class="Grid-cell Grid-Sidebar u-sizeFull u-md-size4of12 u-lg-size4of12 u-margin-bottom-l" itemscope itemtype="http://schema.org/WPSideBar">
        <?php if ( is_active_sidebar( 'trasparenza-sidebar' ) ) :
          dynamic_sidebar( 'trasparenza-sidebar' );
        endif; ?>
      </aside>
	</div>

</section>

<?php get_footer(); ?>
